/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewStructureMode;

public final class PatternType
implements IStandardEnumeration {
    private final IAssignableAttributeRetriever m_retriever;

    public PatternType(IAssignableAttributeRetriever retriever) {
        assert (retriever != null) : "Parameter 'retriever' of method 'PatternType' must not be null";
        this.m_retriever = retriever;
    }

    public String getPresentationName() {
        return this.m_retriever.getPresentationName();
    }

    public String getStandardName() {
        String standardName = this.m_retriever.getShortName().replace(" ", "");
        Language language = this.m_retriever.getLanguage();
        standardName = String.valueOf(language == null ? "core." : String.valueOf(language.getStandardName().toLowerCase()) + ".") + Character.toLowerCase(standardName.charAt(0)) + standardName.substring(1);
        return standardName;
    }

    public String getPatternPrefix() {
        return String.valueOf(this.m_retriever.getName()) + ": ";
    }

    public IAssignableAttributeRetriever getAttributeRetriever() {
        return this.m_retriever;
    }

    public String getDescription(ExplorationViewStructureMode structureMode) {
        assert (structureMode != null) : "Parameter 'structureMode' of method 'getDescription' must not be null";
        return this.m_retriever.getDescription(structureMode.getArchitectureModel());
    }
}

