/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewOperationExecutor;
import com.hello2morrow.sonargraph.core.model.explorationview.OperationInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.TargetParentOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MoveElementsOperation
extends TargetParentOperation {
    private final List<String> m_elements;
    private OperationInfo m_operationInfo;

    public MoveElementsOperation(NamedElement parent, PresentationMode presentationMode, String targetParent, int atPos, List<String> elements) {
        super(parent, presentationMode, targetParent, atPos);
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'MoveElementsOperation' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'MoveElementsOperation' must not be empty";
        this.m_elements = new ArrayList<String>(elements);
    }

    public MoveElementsOperation(NamedElement parent, PresentationMode presentationMode, String targetParent, int atPos, List<String> elements, OperationInfo operationInfo) {
        this(parent, presentationMode, targetParent, atPos, elements);
        assert (operationInfo != null) : "Parameter 'operationInfo' of method 'MoveElementsOperation' must not be null";
        this.m_operationInfo = operationInfo;
    }

    private MoveElementsOperation(NamedElement parent, MoveElementsOperation copyOf) {
        super(parent, copyOf);
        assert (copyOf != null) : "Parameter 'copyOf' of method 'MoveElementsOperation' must not be null";
        this.m_elements = new ArrayList<String>(copyOf.m_elements);
    }

    @Override
    public ArchitecturalViewOperation copy(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'copy' must not be null";
        return new MoveElementsOperation(parent, this);
    }

    @Override
    public String getImageResourceName() {
        return "MoveElements";
    }

    @Override
    public String getShortName() {
        return "Move elements";
    }

    public List<String> getElements() {
        return Collections.unmodifiableList(this.m_elements);
    }

    @Override
    public String getInformation() {
        String targetParent = this.getTargetParentPresentationName();
        int targetPos = this.getTargetPos();
        String additionalInfo = this.m_operationInfo != null ? this.m_operationInfo.getInfo() : "";
        return String.valueOf(super.getInformation()) + " Move " + this.m_elements.size() + " element" + (this.m_elements.size() > 1 ? "s" : "") + (targetParent.isEmpty() ? "" : " to '" + this.getTargetParentPresentationName() + "'") + (targetPos != -1 ? " to pos: " + targetPos : "") + (additionalInfo.isEmpty() ? additionalInfo : " (" + additionalInfo + ")");
    }

    @Property
    public List<String> getInformationElement() {
        if (this.m_operationInfo != null) {
            return this.m_operationInfo.getElementInfo();
        }
        return Collections.unmodifiableList(this.m_elements);
    }

    @Override
    public void apply(IArchitecturalViewOperationExecutor executor) {
        assert (executor != null) : "Parameter 'executor' of method 'apply' must not be null";
        this.m_operationInfo = executor.moveElements(this, this.getTargetParent(), this.getTargetPos(), this.m_elements);
        assert (this.m_operationInfo != null) : "'m_operationInfo' of method 'apply' must not be null";
    }

    @Override
    public void reset() {
        this.m_operationInfo = null;
        super.reset();
    }

    @Override
    public boolean containsRefactoring() {
        return this.m_operationInfo != null ? this.m_operationInfo.containsRefactoring() : false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("\n");
        builder.append("Move ").append(this.m_elements.size()).append(" elements:");
        for (String next : this.m_elements) {
            builder.append("\n");
            builder.append("Element: ").append(next);
        }
        return builder.toString();
    }
}

