/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.MovableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementAggregatingNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MoveElementsInfo {
    private final Map<ArtifactNode, String> m_notMovableArtifacts = new LinkedHashMap<ArtifactNode, String>();
    private final Map<AssignableNode, String> m_notMovableAssignables = new LinkedHashMap<AssignableNode, String>();
    private final Set<ArtifactNode> m_toBeMoved = new LinkedHashSet<ArtifactNode>();
    private final Set<AssignableNode> m_toBeAssigned = new LinkedHashSet<AssignableNode>();
    private final Set<AssignableNode> m_toBeRefactored = new LinkedHashSet<AssignableNode>();
    private final Set<AssignableNode> m_toBeRefactoredAndAssigned = new LinkedHashSet<AssignableNode>();
    private final Set<String> m_relativePaths = new LinkedHashSet<String>();
    private final Set<String> m_elementInfo = new LinkedHashSet<String>();
    private final ExplorationViewRepresentation m_representation;
    private final MovableTargetInfo m_targetInfo;
    private String m_additionalInfo;

    public MoveElementsInfo(ExplorationViewRepresentation representation, MovableTargetInfo targetInfo) {
        assert (representation != null) : "Parameter 'representation' of method 'MoveElementsInfo' must not be null";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'MoveElementsInfo' must not be null";
        this.m_representation = representation;
        this.m_targetInfo = targetInfo;
    }

    public ExplorationViewRepresentation getRepresentation() {
        return this.m_representation;
    }

    public void setAdditionalOverallInfo(String info) {
        assert (info != null && info.length() > 0) : "Parameter 'info' of method 'setAdditionalOverallInfo' must not be empty";
        assert (this.isApplicable()) : "Not applicable";
        assert (this.m_additionalInfo == null) : "'m_additionalInfo' of method 'setAdditionalOverallInfo' must be null";
        this.m_additionalInfo = info;
    }

    public boolean containsRefactoring() {
        return !this.m_toBeRefactoredAndAssigned.isEmpty() || !this.m_toBeRefactored.isEmpty();
    }

    public String getInfo() {
        if (!this.isApplicable()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (!this.m_toBeMoved.isEmpty()) {
            builder.append("move");
        }
        if (!this.m_toBeRefactoredAndAssigned.isEmpty()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append("refactoring, assignment");
        } else if (!this.m_toBeRefactored.isEmpty()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append("refactoring");
        } else if (!this.m_toBeAssigned.isEmpty()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append("assignment");
        }
        if (this.m_additionalInfo != null) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(this.m_additionalInfo);
        }
        return builder.toString();
    }

    public MovableTargetInfo getTargetInfo() {
        return this.m_targetInfo;
    }

    public void addNotMovable(ArtifactNode artifact, String info) {
        assert (artifact != null) : "Parameter 'artifact' of method 'addNotMovable' must not be null";
        assert (info != null && info.length() > 0) : "Parameter 'info' of method 'addNotMovable' must not be empty";
        assert (!this.m_toBeMoved.contains(artifact)) : "Artifact already added as movable: " + artifact;
        String previous = this.m_notMovableArtifacts.put(artifact, info);
        assert (previous == null) : "'previous' of method 'addNotMovable' must be null";
        this.m_elementInfo.add("'" + artifact.getName() + "' not movable: " + info);
    }

    public void addToBeMoved(ArtifactNode artifact) {
        assert (artifact != null) : "Parameter 'artifact' of method 'addToBeMoved' must not be null";
        assert (!this.m_notMovableArtifacts.containsKey(artifact)) : "Artifact already added as not movable: " + artifact;
        boolean success = this.m_toBeMoved.add(artifact);
        assert (success) : "Movable artifact already added: " + artifact;
        this.m_relativePaths.add(artifact.getRelativePath());
        this.m_elementInfo.add("'" + artifact.getName() + "' movable");
    }

    public void addNotMovable(AssignableNode assignable, String info) {
        assert (assignable != null) : "Parameter 'assignable' of method 'addNotMovable' must not be null";
        assert (info != null && info.length() > 0) : "Parameter 'info' of method 'addNotMovable' must not be empty";
        String previous = this.m_notMovableAssignables.put(assignable, info);
        assert (previous == null) : "'previous' of method 'addNotMovable' must be null";
        this.m_elementInfo.add("'" + assignable.getName() + "' not movable: " + info);
    }

    public void addToBeAssigned(AssignableNode assignable) {
        assert (assignable != null) : "Parameter 'artifact' of method 'addToBeAssigned' must not be null";
        assert (!this.m_notMovableAssignables.containsKey(assignable)) : "Assignable already added as not movable: " + assignable;
        assert (!this.m_toBeRefactoredAndAssigned.contains(assignable)) : "Assignable already added as refactorable and assignable: " + assignable;
        assert (!this.m_toBeRefactored.contains(assignable)) : "Assignable already added as refactorable: " + assignable;
        boolean success = this.m_toBeAssigned.add(assignable);
        assert (success) : "Movable assignable already added: " + assignable;
        this.m_relativePaths.add(assignable.getRelativePath());
        this.m_elementInfo.add("'" + assignable.getName() + "' assigned");
    }

    public void addToBeRefactoredAndAssigned(AssignableNode assignable) {
        assert (assignable != null) : "Parameter 'artifact' of method 'addToBeRefactoredAndAssigned' must not be null";
        assert (!this.m_notMovableAssignables.containsKey(assignable)) : "Assignable already added as not movable: " + assignable;
        assert (!this.m_toBeRefactored.contains(assignable)) : "Assignable already added as refactorable: " + assignable;
        assert (!this.m_toBeAssigned.contains(assignable)) : "Assignable already added as assignable: " + assignable;
        boolean success = this.m_toBeRefactoredAndAssigned.add(assignable);
        assert (success) : "Movable assignable already added: " + assignable;
        this.m_relativePaths.add(assignable.getRelativePath());
        this.m_elementInfo.add("'" + assignable.getName() + "' refactored and assigned");
    }

    public void addToBeRefactored(AssignableNode assignable) {
        assert (assignable != null) : "Parameter 'artifact' of method 'addToBeRefactored' must not be null";
        assert (!this.m_notMovableAssignables.containsKey(assignable)) : "Assignable already added as not movable: " + assignable;
        assert (!this.m_toBeRefactoredAndAssigned.contains(assignable)) : "Assignable already added as refactorable and assignable: " + assignable;
        assert (!this.m_toBeAssigned.contains(assignable)) : "Assignable already added as assignable: " + assignable;
        boolean success = this.m_toBeRefactored.add(assignable);
        assert (success) : "Movable assignable already added: " + assignable;
        this.m_relativePaths.add(assignable.getRelativePath());
        this.m_elementInfo.add("'" + assignable.getName() + "' refactored");
    }

    public void addElementInfo(String info) {
        assert (info != null && info.length() > 0) : "Parameter 'info' of method 'addElementInfo' must not be empty";
        this.m_elementInfo.add(info);
    }

    public boolean isApplicable() {
        return !this.m_relativePaths.isEmpty();
    }

    public boolean hasArtifactsToMove() {
        return !this.m_toBeMoved.isEmpty();
    }

    public boolean hasAssignablesToAssign() {
        return !this.m_toBeAssigned.isEmpty();
    }

    public boolean hasAssignablesToRefactor() {
        return !this.m_toBeRefactoredAndAssigned.isEmpty() || !this.m_toBeRefactored.isEmpty();
    }

    public boolean hasAdditionalElementInfo() {
        return this.m_elementInfo.size() > this.m_relativePaths.size();
    }

    public List<String> getRelativePaths() {
        assert (this.isApplicable()) : "Not applicable: " + this;
        return new ArrayList<String>(this.m_relativePaths);
    }

    public Set<ArtifactNode> getArtifactsToToMove() {
        assert (this.isApplicable()) : "Not applicable: " + this;
        return Collections.unmodifiableSet(this.m_toBeMoved);
    }

    public Set<AssignableNode> getAssignablesToAssign() {
        assert (this.isApplicable()) : "Not applicable: " + this;
        return Collections.unmodifiableSet(this.m_toBeAssigned);
    }

    public Set<AssignableNode> getAssignablesToRefactor() {
        assert (this.isApplicable()) : "Not applicable: " + this;
        LinkedHashSet<AssignableNode> all = new LinkedHashSet<AssignableNode>(this.m_toBeRefactoredAndAssigned);
        all.addAll(this.m_toBeRefactored);
        return Collections.unmodifiableSet(all);
    }

    public List<String> getElementInfo() {
        return new ArrayList<String>(this.m_elementInfo);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("### ");
        builder.append(this.getClass().getSimpleName()).append(" ###").append("\n");
        builder.append("Move element(s) to: ").append(this.m_targetInfo);
        builder.append("\n");
        builder.append(this.m_notMovableArtifacts.size()).append(" not movable artifact(s)");
        int i2 = 1;
        for (Map.Entry<ArtifactNode, String> entry : this.m_notMovableArtifacts.entrySet()) {
            builder.append("\n");
            builder.append("[").append(i2).append("] ").append(entry.getKey().getName()).append(": ").append(entry.getValue());
            ++i2;
        }
        builder.append("\n");
        builder.append(this.m_notMovableAssignables.size()).append(" not movable assignable(s)");
        i2 = 1;
        for (Map.Entry<ProgrammingElementAggregatingNode, String> entry : this.m_notMovableAssignables.entrySet()) {
            builder.append("\n");
            builder.append("[").append(i2).append("] ").append(((AssignableNode)entry.getKey()).getName()).append(": ").append(entry.getValue());
            ++i2;
        }
        builder.append("\n");
        builder.append(this.m_toBeMoved.size()).append(" artifact(s) to move");
        i2 = 1;
        for (ArtifactNode artifactNode : this.m_toBeMoved) {
            builder.append("\n");
            builder.append("[").append(i2).append("] ").append(artifactNode.getName());
            ++i2;
        }
        builder.append("\n");
        builder.append(this.m_toBeAssigned.size()).append(" assignable(s) to assign");
        i2 = 1;
        for (AssignableNode assignableNode : this.m_toBeAssigned) {
            builder.append("\n");
            builder.append("[").append(i2).append("] ").append(assignableNode.getName());
            ++i2;
        }
        builder.append("\n");
        builder.append(this.m_toBeRefactoredAndAssigned.size()).append(" assignable(s) to refactor and assign");
        i2 = 1;
        for (AssignableNode assignableNode : this.m_toBeRefactoredAndAssigned) {
            builder.append("\n");
            builder.append("[").append(i2).append("] ").append(assignableNode.getName());
            ++i2;
        }
        builder.append("\n");
        builder.append(this.m_toBeRefactored.size()).append(" assignable(s) to refactor");
        i2 = 1;
        for (AssignableNode assignableNode : this.m_toBeRefactored) {
            builder.append("\n");
            builder.append("[").append(i2).append("] ").append(assignableNode.getName());
            ++i2;
        }
        builder.append("\n");
        builder.append(this.m_relativePaths.size()).append(" movable relative path(s)");
        i2 = 1;
        for (String string : this.m_relativePaths) {
            builder.append("\n");
            builder.append("[").append(i2).append("] ").append(string);
            ++i2;
        }
        builder.append("\n");
        builder.append(this.m_elementInfo.size()).append(" element(s)");
        i2 = 1;
        for (String string : this.m_elementInfo) {
            builder.append("\n");
            builder.append("[").append(i2).append("] ").append(string);
            ++i2;
        }
        return builder.toString();
    }
}

