/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public final class ManualFilter {
    private final Set<String> m_includes = new TreeSet<String>();
    private final Set<String> m_excludes = new TreeSet<String>();

    public ManualFilter(Collection<String> includes, Collection<String> excludes) {
        boolean success;
        assert (includes != null && !includes.isEmpty()) : "Parameter 'includes' of method 'ManualFilter' must not be empty";
        assert (excludes != null) : "Parameter 'excludes' of method 'ManualFilter' must not be null";
        HashSet<String> allPatterns = new HashSet<String>();
        for (String next : includes) {
            success = allPatterns.add(next);
            assert (success) : "Duplicate pattern: " + next;
            success = this.m_includes.add(next);
            assert (success) : "Duplicate include: " + next;
        }
        for (String next : excludes) {
            success = allPatterns.add(next);
            assert (success) : "Duplicate pattern: " + next;
            success = this.m_excludes.add(next);
            assert (success) : "Duplicate exclude: " + next;
        }
    }

    public ManualFilter copy() {
        return new ManualFilter(this.m_includes, this.m_excludes);
    }

    public Collection<String> getIncludes() {
        return Collections.unmodifiableCollection(this.m_includes);
    }

    public Collection<String> getExcludes() {
        return Collections.unmodifiableCollection(this.m_excludes);
    }

    @Property
    public String getFilterInfo() {
        StringBuilder info = new StringBuilder();
        info.append("Manual with ").append(this.m_includes.size()).append(" include(s) and ").append(this.m_excludes.size()).append(" exclude(s)");
        for (String nextInclude : this.m_includes) {
            info.append(StringUtility.LINE_SEPARATOR);
            info.append(ArtifactNodeFilter.PatternKind.INCLUDE.getPresentationName()).append(": ").append(nextInclude);
        }
        for (String nextExclude : this.m_excludes) {
            info.append(StringUtility.LINE_SEPARATOR);
            info.append(ArtifactNodeFilter.PatternKind.EXCLUDE.getPresentationName()).append(": ").append(nextExclude);
        }
        return info.toString();
    }
}

