/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewOperationExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class HideElementsOperation
extends ArchitecturalViewOperation {
    final List<String> m_elements;

    public HideElementsOperation(NamedElement parent, PresentationMode presentationMode, List<String> elements) {
        super(parent, presentationMode);
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'HideElementsOperation' must not be empty";
        this.m_elements = new ArrayList<String>(elements);
    }

    private HideElementsOperation(NamedElement parent, HideElementsOperation copyOf) {
        super(parent, copyOf);
        assert (copyOf != null) : "Parameter 'copyOf' of method 'HideElementsOperation' must not be null";
        this.m_elements = new ArrayList<String>(copyOf.m_elements);
    }

    @Override
    public ArchitecturalViewOperation copy(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'copy' must not be null";
        return new HideElementsOperation(parent, this);
    }

    @Override
    public String getImageResourceName() {
        return "HideElements";
    }

    @Override
    public String getShortName() {
        return "Hide elements";
    }

    public List<String> getElements() {
        return Collections.unmodifiableList(this.m_elements);
    }

    @Override
    public String getInformation() {
        return String.valueOf(super.getInformation()) + " Hide " + this.m_elements.size() + " element" + (this.m_elements.size() > 1 ? "s" : "");
    }

    @Property
    public List<String> getInformationHiddenElement() {
        return Collections.unmodifiableList(this.m_elements);
    }

    @Override
    public void apply(IArchitecturalViewOperationExecutor executor) {
        assert (executor != null) : "Parameter 'executor' of method 'apply' must not be null";
        executor.hideElements(this, this.m_elements);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        for (String next : this.m_elements) {
            builder.append("\n");
            builder.append("Hide element: ").append(next);
        }
        return builder.toString();
    }
}

