/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import java.util.Collection;

public final class ExplorationViewStructureMode
extends Enum<ExplorationViewStructureMode>
implements IStandardEnumeration {
    public static final /* enum */ ExplorationViewStructureMode PHYSICAL_WITH_ROOT_DIRECTORIES = new ExplorationViewStructureMode(IArchitecturalModelProvider.ArchitectureModel.PHYSICAL, "Physical");
    public static final /* enum */ ExplorationViewStructureMode PHYSICAL_WITHOUT_ROOT_DIRECTORIES = new ExplorationViewStructureMode(IArchitecturalModelProvider.ArchitectureModel.PHYSICAL, "Physical w/o Root Directories");
    public static final /* enum */ ExplorationViewStructureMode LOGICAL_MODULE_SCOPE = new ExplorationViewStructureMode(IArchitecturalModelProvider.ArchitectureModel.LOGICAL, "Logical Module Scope");
    public static final /* enum */ ExplorationViewStructureMode LOGICAL_SYSTEM_SCOPE = new ExplorationViewStructureMode(IArchitecturalModelProvider.ArchitectureModel.LOGICAL, "Logical System Scope");
    private final IArchitecturalModelProvider.ArchitectureModel m_architectureModel;
    private final String m_presentationName;
    private static final /* synthetic */ ExplorationViewStructureMode[] ENUM$VALUES;

    static {
        ENUM$VALUES = new ExplorationViewStructureMode[]{PHYSICAL_WITH_ROOT_DIRECTORIES, PHYSICAL_WITHOUT_ROOT_DIRECTORIES, LOGICAL_MODULE_SCOPE, LOGICAL_SYSTEM_SCOPE};
    }

    private ExplorationViewStructureMode(IArchitecturalModelProvider.ArchitectureModel architectureModel, String presentationName) {
        assert (architectureModel != null) : "Parameter 'architectureModel' of method 'ExplorationViewStructureMode' must not be null";
        assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'ExplorationViewStructureMode' must not be empty";
        this.m_presentationName = presentationName;
        this.m_architectureModel = architectureModel;
    }

    public IArchitecturalModelProvider.ArchitectureModel getArchitectureModel() {
        return this.m_architectureModel;
    }

    public boolean isPhysical() {
        return this.m_architectureModel.getDomain().isPhysical();
    }

    public boolean isLogical() {
        return this.m_architectureModel.getDomain().isLogical();
    }

    public boolean isAvailableFor(Collection<Language> languages) {
        if (languages == null || languages.isEmpty()) {
            return true;
        }
        switch (this) {
            case LOGICAL_MODULE_SCOPE: 
            case LOGICAL_SYSTEM_SCOPE: {
                boolean available = true;
                for (Language nextLanguage : languages) {
                    if (nextLanguage.hasLogicalModel()) continue;
                    available = false;
                }
                return available;
            }
            case PHYSICAL_WITH_ROOT_DIRECTORIES: 
            case PHYSICAL_WITHOUT_ROOT_DIRECTORIES: {
                return true;
            }
        }
        assert (false) : "Unhandled: " + (Object)((Object)this);
        return false;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    public static ExplorationViewStructureMode fromStandardName(String standardName) {
        assert (standardName != null) : "'standardName' must not be null";
        assert (standardName.length() > 0) : "'standardName' must not be empty";
        String name = StringUtility.convertStandardNameToConstantName((String)standardName);
        return ExplorationViewStructureMode.valueOf(name);
    }

    public static ExplorationViewStructureMode getDefault() {
        return PHYSICAL_WITHOUT_ROOT_DIRECTORIES;
    }

    public static ExplorationViewStructureMode[] values() {
        ExplorationViewStructureMode[] explorationViewStructureModeArray = ENUM$VALUES;
        int n2 = explorationViewStructureModeArray.length;
        ExplorationViewStructureMode[] explorationViewStructureModeArray2 = new ExplorationViewStructureMode[n2];
        System.arraycopy(ENUM$VALUES, 0, explorationViewStructureModeArray2, 0, n2);
        return explorationViewStructureModeArray2;
    }

    public static ExplorationViewStructureMode valueOf(String string) {
        return Enum.valueOf(ExplorationViewStructureMode.class, string);
    }
}

