/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.utilities.IntBitFieldUtil;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;

final class ExplorationViewNodeFlags {
    static final int MIXED = 1;
    static final int FLAT = 2;
    static final int NONE = 4;
    static final int EXPANDABLE = 8;
    static final int EXPANDED = 16;
    static final int SELECTED = 32;
    static final int HAS_VIOLATION = 64;
    static final int HAS_DEPRECATION = 128;
    static final int HIDDEN = 256;
    static final int REFACTORED = 512;
    static final int DELETED = 1024;
    static final int DELETED_FLAT = 2048;
    static final int REMOVED_BY_FOCUS = 4096;
    static final int HAS_PARTIAL_ELEMENTS = 8192;
    static final int HAS_PARTIAL_DEPENDENCIES = 16384;
    static final int SUPPRESS = 32768;
    static final int PART = 65536;
    static final int DELETED_RECYCLED = 131072;
    static final int READ_ONLY = 262144;
    static final int LAZY_EXPANDABLE = 524288;

    private ExplorationViewNodeFlags() {
    }

    static int setPresentationMode(PresentationMode presentationMode, int flags) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'setPresentationMode' must not be null";
        switch (presentationMode) {
            case HIERARCHICAL: {
                flags = IntBitFieldUtil.disableFlag((int)flags, (int)1);
                flags = IntBitFieldUtil.disableFlag((int)flags, (int)2);
                flags = IntBitFieldUtil.disableFlag((int)flags, (int)4);
                break;
            }
            case MIXED: {
                flags = IntBitFieldUtil.enableFlag((int)flags, (int)1);
                flags = IntBitFieldUtil.disableFlag((int)flags, (int)2);
                flags = IntBitFieldUtil.disableFlag((int)flags, (int)4);
                break;
            }
            case FLAT: {
                flags = IntBitFieldUtil.enableFlag((int)flags, (int)2);
                flags = IntBitFieldUtil.disableFlag((int)flags, (int)1);
                flags = IntBitFieldUtil.disableFlag((int)flags, (int)4);
                break;
            }
            case NONE: {
                flags = IntBitFieldUtil.disableFlag((int)flags, (int)1);
                flags = IntBitFieldUtil.disableFlag((int)flags, (int)2);
                flags = IntBitFieldUtil.enableFlag((int)flags, (int)4);
                break;
            }
            default: {
                assert (false) : "Unhandled presentation mode: " + (Object)((Object)presentationMode);
                break;
            }
        }
        return flags;
    }

    static PresentationMode getPresentationMode(int flags) {
        if (IntBitFieldUtil.isFlagEnabled((int)flags, (int)1)) {
            assert (!IntBitFieldUtil.isFlagEnabled((int)flags, (int)2)) : "Also enabled 'FLAT'";
            assert (!IntBitFieldUtil.isFlagEnabled((int)flags, (int)4)) : "Also enabled 'NONE'";
            return PresentationMode.MIXED;
        }
        if (IntBitFieldUtil.isFlagEnabled((int)flags, (int)2)) {
            assert (!IntBitFieldUtil.isFlagEnabled((int)flags, (int)1)) : "Also enabled 'MIXED'";
            assert (!IntBitFieldUtil.isFlagEnabled((int)flags, (int)4)) : "Also enabled 'NONE'";
            return PresentationMode.FLAT;
        }
        if (IntBitFieldUtil.isFlagEnabled((int)flags, (int)4)) {
            assert (!IntBitFieldUtil.isFlagEnabled((int)flags, (int)1)) : "Also enabled 'MIXED'";
            assert (!IntBitFieldUtil.isFlagEnabled((int)flags, (int)2)) : "Also enabled 'FLAT'";
            return PresentationMode.NONE;
        }
        return PresentationMode.HIERARCHICAL;
    }

    static boolean isEnabled(int flags, int flag) {
        return IntBitFieldUtil.isFlagEnabled((int)flags, (int)flag);
    }

    static int setEnabled(boolean enable, int flags, int flag) {
        return enable ? IntBitFieldUtil.enableFlag((int)flags, (int)flag) : IntBitFieldUtil.disableFlag((int)flags, (int)flag);
    }
}

