/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewMetric;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;

public final class ExplorationViewMetrics {
    private final Set<ExplorationViewMetric> m_metrics = new TreeSet<ExplorationViewMetric>(new Comparator<ExplorationViewMetric>(){

        @Override
        public int compare(ExplorationViewMetric m1, ExplorationViewMetric m2) {
            if (!$assertionsDisabled && m1 == null) {
                throw new AssertionError((Object)"Parameter 'm1' of method 'enclosing_method' must not be null");
            }
            if (!$assertionsDisabled && m2 == null) {
                throw new AssertionError((Object)"Parameter 'm2' of method 'enclosing_method' must not be null");
            }
            return m1.getOrdinal() - m2.getOrdinal();
        }
    });
    private final Set<ArchitecturalViewElement> m_elements;
    private final String m_namespacePresentationNames;
    private final ExplorationViewRepresentation m_representation;
    private final long m_creationTimestamp;

    public ExplorationViewMetrics(Set<ArchitecturalViewElement> elements, Set<String> namespacePresentationNames, ExplorationViewRepresentation representation) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'ExplorationViewMetrics' must not be empty";
        assert (namespacePresentationNames != null && !namespacePresentationNames.isEmpty()) : "Parameter 'namespacePresentationNames' of method 'ExplorationViewMetrics' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'ExplorationViewMetrics' must not be null";
        this.m_elements = new LinkedHashSet<ArchitecturalViewElement>(elements);
        ArrayList names = new ArrayList(namespacePresentationNames.size());
        namespacePresentationNames.forEach(n2 -> {
            boolean bl2 = names.add(String.valueOf(n2) + "s");
        });
        this.m_namespacePresentationNames = StringUtility.concat(names, (String)"/");
        this.m_representation = representation;
        this.m_creationTimestamp = System.currentTimeMillis();
    }

    public ExplorationViewRepresentation getRepresentation() {
        return this.m_representation;
    }

    public String getNamespacePresentationNames() {
        return this.m_namespacePresentationNames;
    }

    public Set<ArchitecturalViewElement> getElements() {
        return Collections.unmodifiableSet(this.m_elements);
    }

    public boolean completeRepresentation() {
        return this.m_elements.size() == 1 && this.m_elements.iterator().next() == this.m_representation;
    }

    public long getCreationTimestamp() {
        return this.m_creationTimestamp;
    }

    public void addMetric(ExplorationViewMetric metric) {
        assert (metric != null) : "Parameter 'metric' of method 'addMetric' must not be null";
        boolean success = this.m_metrics.add(metric);
        assert (success) : "Metric already added: " + metric;
    }

    public Set<ExplorationViewMetric> getMetrics() {
        return Collections.unmodifiableSet(this.m_metrics);
    }

    public String getInfo() {
        if (this.completeRepresentation()) {
            return "Metrics calculated for all elements" + (this.m_representation.getFocus().isEmpty() ? "" : " with applied focus") + ".";
        }
        return "Metrics calculated for " + this.m_elements.size() + " selected element(s)" + (this.m_representation.getFocus().isEmpty() ? "" : " with applied focus") + ".";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (ExplorationViewMetric next : this.m_metrics) {
            builder.append(next).append("\n");
        }
        return builder.toString();
    }
}

