/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.PartialAlternativeInfo;
import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class ExplorationViewFocusProperties {
    private final Set<IParserDependencyType> m_availableParserDependencyTypes = new TreeSet<IParserDependencyType>(new Comparator<IParserDependencyType>(){

        @Override
        public int compare(IParserDependencyType t1, IParserDependencyType t2) {
            if (!$assertionsDisabled && t1 == null) {
                throw new AssertionError((Object)"Parameter 't1' of method 'enclosing_method' must not be null");
            }
            if (!$assertionsDisabled && t2 == null) {
                throw new AssertionError((Object)"Parameter 't2' of method 'enclosing_method' must not be null");
            }
            return t1.getPresentationName().compareTo(t2.getPresentationName());
        }
    });
    private final Set<IParserDependencyType> m_parserDependencyTypes;
    private final EnumSet<FocusType> m_availableFocusTypes;
    private final boolean m_offerNodeInclusionModes;
    private final boolean m_offerDependencyInclusionModes;
    private final String m_info;
    private final PartialAlternativeInfo m_partialAlternativeInfo;
    private FocusType m_focusType;
    private NodeInclusionMode m_nodeInclusionMode = NodeInclusionMode.NODES_IN_AND_OUT;
    private DependencyInclusionMode m_dependencyInclusionMode = DependencyInclusionMode.ALL_DEPENDENCIES;
    private boolean m_expandToAssignableToArtifactLevel;
    private boolean m_usePartialAlternative;

    public ExplorationViewFocusProperties(FocusType focusType, EnumSet<FocusType> availableFocusTypes, boolean offerNodeInclusionModes, boolean offerDependencyInclusionModes, Collection<IParserDependencyType> availableParserDependencyTypes, String info, PartialAlternativeInfo partialAlternativeInfo) {
        assert (focusType != null) : "Parameter 'focusType' of method 'ExplorationViewFocusProperties' must not be null";
        assert (availableFocusTypes != null && !availableFocusTypes.isEmpty()) : "Parameter 'availableFocusTypes' of method 'ExplorationViewFocusProperties' must not be empty";
        assert (availableParserDependencyTypes != null && !availableParserDependencyTypes.isEmpty()) : "Parameter 'availableParserDependencyTypes' of method 'ExplorationViewFocusProperties' must not be empty";
        assert (info != null) : "Parameter 'info' of method 'ExplorationViewFocusProperties' must not be null";
        this.m_focusType = focusType;
        this.m_offerNodeInclusionModes = offerNodeInclusionModes;
        this.m_offerDependencyInclusionModes = offerDependencyInclusionModes;
        this.m_availableFocusTypes = EnumSet.copyOf(availableFocusTypes);
        this.m_availableParserDependencyTypes.addAll(availableParserDependencyTypes);
        this.m_parserDependencyTypes = new THashSet(this.m_availableParserDependencyTypes);
        this.m_info = info;
        this.m_partialAlternativeInfo = partialAlternativeInfo;
    }

    public String getInfo() {
        return this.m_info;
    }

    public PartialAlternativeInfo getPartialAlternativeInfo() {
        return this.m_partialAlternativeInfo;
    }

    public void usePartialAlternative(boolean usePartialAlternative) {
        assert (this.m_partialAlternativeInfo != null) : "'m_partialAlternativeInfo' of method 'setUsePartialAlternative' must not be null";
        this.m_usePartialAlternative = usePartialAlternative;
    }

    public List<ArchitecturalViewNode> getPartialAlternative() {
        if (this.m_usePartialAlternative) {
            assert (this.m_partialAlternativeInfo != null) : "'m_partialAlternativeInfo' of method 'getPartialAlternative' must not be null";
            return this.m_partialAlternativeInfo.getAlternativeNodes();
        }
        return null;
    }

    public void setFocusType(FocusType focusType) {
        assert (focusType != null) : "Parameter 'focusType' of method 'setFocusType' must not be null";
        assert (this.m_focusType.supportUserInteraction()) : "User interaction not supported";
        assert (this.m_availableFocusTypes.contains((Object)focusType));
        this.m_focusType = focusType;
    }

    public void setNodeInclusionMode(NodeInclusionMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'setNodeInclusionMode' must not be null";
        assert (this.m_focusType.supportUserInteraction()) : "User interaction not supported";
        assert (this.m_offerNodeInclusionModes) : "No node inclusion mode offered";
        this.m_nodeInclusionMode = mode;
    }

    public void setDependencyInclusionMode(DependencyInclusionMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'setDependencyInclusionMode' must not be null";
        assert (this.m_focusType.supportUserInteraction()) : "User interaction not supported";
        assert (this.m_offerDependencyInclusionModes) : "No dependency inclusion mode offered";
        this.m_dependencyInclusionMode = mode;
    }

    public void setExpandToAssignableToArtifactLevel(boolean expand) {
        assert (this.m_focusType.supportUserInteraction()) : "User interaction not supported";
        this.m_expandToAssignableToArtifactLevel = expand;
    }

    public FocusType getFocusType() {
        return this.m_focusType;
    }

    public boolean expandToAssignableToArtifactLevel() {
        return this.m_expandToAssignableToArtifactLevel;
    }

    public EnumSet<FocusType> getAvailableFocusTypes() {
        return EnumSet.copyOf(this.m_availableFocusTypes);
    }

    public List<NodeInclusionMode> getAvailableNodeInclusionModes() {
        if (this.m_focusType.supportUserInteraction() && this.m_offerNodeInclusionModes) {
            return Arrays.asList(NodeInclusionMode.values());
        }
        return Collections.emptyList();
    }

    public NodeInclusionMode getNodeInclusionMode() {
        return this.m_nodeInclusionMode;
    }

    public List<DependencyInclusionMode> getAvailableDependencyInclusionModes() {
        if (this.m_focusType.supportUserInteraction() && this.m_offerDependencyInclusionModes) {
            return Arrays.asList(DependencyInclusionMode.values());
        }
        return Collections.emptyList();
    }

    public DependencyInclusionMode getDependencyInclusionMode() {
        return this.m_dependencyInclusionMode;
    }

    public Collection<IParserDependencyType> getAvailableParserDependencyTypes() {
        return Collections.unmodifiableSet(this.m_availableParserDependencyTypes);
    }

    public Set<IParserDependencyType> getParserDependencyTypes() {
        return Collections.unmodifiableSet(this.m_parserDependencyTypes);
    }

    public void removeAllParserDependencyTypes() {
        this.m_parserDependencyTypes.clear();
    }

    public void addAllParserDependencyTypes() {
        this.m_parserDependencyTypes.addAll(this.m_availableParserDependencyTypes);
    }

    public void addToParserDependencyTypes(IParserDependencyType type) {
        assert (type != null) : "Parameter 'type' of method 'setParserDependencyType' must not be null";
        assert (this.m_availableParserDependencyTypes.contains(type)) : "Not available: " + type;
        this.m_parserDependencyTypes.add(type);
    }

    public void removeFromParserDependencyTypes(IParserDependencyType type) {
        assert (type != null) : "Parameter 'type' of method 'setParserDependencyType' must not be null";
        this.m_parserDependencyTypes.remove(type);
    }

    public boolean includesAllDependencies() {
        return DependencyInclusionMode.ALL_DEPENDENCIES.equals((Object)this.m_dependencyInclusionMode) && this.m_parserDependencyTypes.size() == this.m_availableParserDependencyTypes.size();
    }

    public boolean isValid() {
        return !this.m_parserDependencyTypes.isEmpty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.getClass().getSimpleName()).append("] ");
        builder.append((Object)this.m_focusType);
        if (this.m_focusType.supportUserInteraction()) {
            builder.append(" (supports user interaction)");
        } else {
            builder.append(" (does not support user interaction)");
        }
        builder.append(", ");
        builder.append((Object)this.m_nodeInclusionMode);
        if (this.m_focusType.supportUserInteraction() && this.m_offerNodeInclusionModes) {
            builder.append(" (offered)");
        } else {
            builder.append(" (not offered)");
        }
        builder.append(", ");
        builder.append((Object)this.m_dependencyInclusionMode);
        if (this.m_focusType.supportUserInteraction() && this.m_offerDependencyInclusionModes) {
            builder.append(" (offered)");
        } else {
            builder.append(" (not offered)");
        }
        builder.append(",");
        if (!this.m_parserDependencyTypes.isEmpty()) {
            for (IParserDependencyType next : this.m_parserDependencyTypes) {
                builder.append(" ");
                builder.append(next);
            }
            if (!this.includesAllDependencies()) {
                builder.append(" (does not include all dependency types)");
            }
        } else {
            builder.append(" NOT_VALID (parser dependency types are empty)");
        }
        if (this.m_expandToAssignableToArtifactLevel) {
            builder.append(" EXPAND_TO_ASSIGNABLE_TO_ARTIFACT_LEVEL");
        }
        if (this.m_usePartialAlternative) {
            builder.append(" USING_PARTIAL_ALTERNATIVE");
        }
        return builder.toString();
    }

    public static final class DependencyInclusionMode
    extends Enum<DependencyInclusionMode>
    implements IStandardEnumeration {
        public static final /* enum */ DependencyInclusionMode ALL_DEPENDENCIES = new DependencyInclusionMode("All");
        public static final /* enum */ DependencyInclusionMode VIOLATING_DEPENDENCIES_ONLY = new DependencyInclusionMode("Violating Only");
        public static final /* enum */ DependencyInclusionMode NON_VIOLATING_DEPENDENCIES_ONLY = new DependencyInclusionMode("Non Violating Only");
        private final String m_presentationName;
        private static final /* synthetic */ DependencyInclusionMode[] ENUM$VALUES;

        static {
            ENUM$VALUES = new DependencyInclusionMode[]{ALL_DEPENDENCIES, VIOLATING_DEPENDENCIES_ONLY, NON_VIOLATING_DEPENDENCIES_ONLY};
        }

        private DependencyInclusionMode(String presentationName) {
            assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'DependencyInclusionMode' must not be empty";
            this.m_presentationName = presentationName;
        }

        public static DependencyInclusionMode fromStandardName(String standardName) throws IllegalArgumentException {
            assert (standardName != null) : "'standardName' must not be null";
            assert (standardName.length() > 0) : "'standardName' must not be empty";
            String name = StringUtility.convertStandardNameToConstantName((String)standardName);
            return DependencyInclusionMode.valueOf(name);
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return this.m_presentationName;
        }

        public static DependencyInclusionMode[] values() {
            DependencyInclusionMode[] dependencyInclusionModeArray = ENUM$VALUES;
            int n2 = dependencyInclusionModeArray.length;
            DependencyInclusionMode[] dependencyInclusionModeArray2 = new DependencyInclusionMode[n2];
            System.arraycopy(ENUM$VALUES, 0, dependencyInclusionModeArray2, 0, n2);
            return dependencyInclusionModeArray2;
        }

        public static DependencyInclusionMode valueOf(String string) {
            return Enum.valueOf(DependencyInclusionMode.class, string);
        }
    }

    public static final class FocusType
    extends Enum<FocusType>
    implements IStandardEnumeration {
        public static final /* enum */ FocusType SET_FOCUS = new FocusType(true);
        public static final /* enum */ FocusType ADD_TO_FOCUS = new FocusType(true);
        public static final /* enum */ FocusType REMOVE_FROM_FOCUS = new FocusType(false);
        private final boolean m_supportUserInteraction;
        private static final /* synthetic */ FocusType[] ENUM$VALUES;

        static {
            ENUM$VALUES = new FocusType[]{SET_FOCUS, ADD_TO_FOCUS, REMOVE_FROM_FOCUS};
        }

        private FocusType(boolean supportUserInteraction) {
            this.m_supportUserInteraction = supportUserInteraction;
        }

        public boolean supportUserInteraction() {
            return this.m_supportUserInteraction;
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }

        public static FocusType fromStandardName(String standardName) throws IllegalArgumentException {
            assert (standardName != null) : "'standardName' must not be null";
            assert (standardName.length() > 0) : "'standardName' must not be empty";
            String name = StringUtility.convertStandardNameToConstantName((String)standardName);
            return FocusType.valueOf(name);
        }

        public static FocusType[] values() {
            FocusType[] focusTypeArray = ENUM$VALUES;
            int n2 = focusTypeArray.length;
            FocusType[] focusTypeArray2 = new FocusType[n2];
            System.arraycopy(ENUM$VALUES, 0, focusTypeArray2, 0, n2);
            return focusTypeArray2;
        }

        public static FocusType valueOf(String string) {
            return Enum.valueOf(FocusType.class, string);
        }
    }

    public static final class NodeInclusionMode
    extends Enum<NodeInclusionMode>
    implements IStandardEnumeration {
        public static final /* enum */ NodeInclusionMode NO_ADDITONAL_NODES = new NodeInclusionMode("No Additional", "Only the selected node(s) and their interdependencies are considered.");
        public static final /* enum */ NodeInclusionMode NODES_IN = new NodeInclusionMode("In", "The selected node(s), their interdependencies and all nodes using the selected node(s) are considered.");
        public static final /* enum */ NodeInclusionMode NODES_OUT = new NodeInclusionMode("Out", "The selected node(s), their interdependencies and all nodes used by the selected node(s) are considered.");
        public static final /* enum */ NodeInclusionMode NODES_IN_AND_OUT = new NodeInclusionMode("In/Out", "The selected node(s), their interdependencies, all nodes using the selected node(s) and all nodes used by the selected node(s) are considered.");
        public static final /* enum */ NodeInclusionMode NODES_IN_TRANSITIVELY = new NodeInclusionMode("In Transitively", "The selected node(s), their interdependencies and all nodes using the selected node(s) transitively are considered.\nLeaf nodes (either components or logical top-level programming elements) are treated as an indivisible unit.");
        public static final /* enum */ NodeInclusionMode NODES_OUT_TRANSITIVELY = new NodeInclusionMode("Out Transitively", "The selected node(s), their interdependencies and all nodes used by the selected node(s) transitively are considered.\nLeaf nodes (either components or logical top-level programming elements) are treated as an indivisible unit.");
        public static final /* enum */ NodeInclusionMode NODES_IN_AND_OUT_TRANSITIVELY = new NodeInclusionMode("In/Out Transitively", "The selected node(s), their interdependencies and all nodes using the selected node(s) and used by the selected node(s) transitively are considered.\nLeaf nodes (either components or logical top-level programming elements) are treated as an indivisible unit.");
        public static final /* enum */ NodeInclusionMode NODES_IN_TRANSITIVELY_PEB = new NodeInclusionMode("In Transitively (programming element based)", "The selected node(s), their interdependencies and all nodes using the selected node(s) transitively are considered.\nLeaf nodes (either components or logical top-level programming elements) are not treated as an indivisible unit. Only the connected programming elements are used.");
        public static final /* enum */ NodeInclusionMode NODES_OUT_TRANSITIVELY_PEB = new NodeInclusionMode("Out Transitively (programming element based)", "The selected node(s), their interdependencies and all nodes used by the selected node(s) transitively are considered.\nLeaf nodes (either components or logical top-level programming elements) are not treated as an indivisible unit. Only the connected programming elements are used.");
        public static final /* enum */ NodeInclusionMode NODES_IN_AND_OUT_TRANSITIVELY_PEB = new NodeInclusionMode("In/Out Transitively (programming element based)", "The selected node(s), their interdependencies and all nodes using the selected node(s) and used by the selected node(s) transitively are considered.\nLeaf nodes (either components or logical top-level programming elements) are not treated as an indivisible unit. Only the connected programming elements are used.");
        private final String m_presentationName;
        private final String m_description;
        private static final /* synthetic */ NodeInclusionMode[] ENUM$VALUES;

        static {
            ENUM$VALUES = new NodeInclusionMode[]{NO_ADDITONAL_NODES, NODES_IN, NODES_OUT, NODES_IN_AND_OUT, NODES_IN_TRANSITIVELY, NODES_OUT_TRANSITIVELY, NODES_IN_AND_OUT_TRANSITIVELY, NODES_IN_TRANSITIVELY_PEB, NODES_OUT_TRANSITIVELY_PEB, NODES_IN_AND_OUT_TRANSITIVELY_PEB};
        }

        private NodeInclusionMode(String presentationName, String description) {
            assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'DependencyInclusionMode' must not be empty";
            assert (description != null && description.length() > 0) : "Parameter 'description' of method 'NodeInclusionMode' must not be empty";
            this.m_presentationName = presentationName;
            this.m_description = description;
        }

        public static NodeInclusionMode fromStandardName(String standardName) throws IllegalArgumentException {
            assert (standardName != null) : "'standardName' must not be null";
            assert (standardName.length() > 0) : "'standardName' must not be empty";
            String name = StringUtility.convertStandardNameToConstantName((String)standardName);
            return NodeInclusionMode.valueOf(name);
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return this.m_presentationName;
        }

        public String getDescription() {
            return this.m_description;
        }

        public static NodeInclusionMode[] values() {
            NodeInclusionMode[] nodeInclusionModeArray = ENUM$VALUES;
            int n2 = nodeInclusionModeArray.length;
            NodeInclusionMode[] nodeInclusionModeArray2 = new NodeInclusionMode[n2];
            System.arraycopy(ENUM$VALUES, 0, nodeInclusionModeArray2, 0, n2);
            return nodeInclusionModeArray2;
        }

        public static NodeInclusionMode valueOf(String string) {
            return Enum.valueOf(NodeInclusionMode.class, string);
        }
    }
}

