/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.utilities.NumberUtility;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.DescriptorCache;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import gnu.trove.set.hash.THashSet;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public final class ExplorationViewFocus {
    public static final DecimalFormat FORMAT = (DecimalFormat)DecimalFormat.getInstance(Locale.getDefault());
    private final Set<ProgrammingElement> m_noAdditionalProgrammingElements = new THashSet();
    private final Set<ProgrammingElement> m_inProgrammingElements = new THashSet();
    private final Set<ProgrammingElement> m_outProgrammingElements = new THashSet();
    private final Set<ProgrammingElement> m_inOutProgrammingElements = new THashSet();
    private final Set<ProgrammingElement> m_removedProgrammingElements = new THashSet();
    private final Set<ParserDependency> m_removedParserDependencies = new THashSet();
    private final Set<ParserDependency> m_addedParserDependencies = new THashSet();
    private int m_internalAssignableToArtifactNodesRemovedByFocus;
    private int m_externalAssignableToArtifactNodesRemovedByFocus;
    private DescriptorCache m_descriptorCache;
    private boolean m_inApply;

    static {
        FORMAT.setRoundingMode(RoundingMode.HALF_UP);
    }

    public ExplorationViewFocus() {
    }

    public ExplorationViewFocus(Set<ProgrammingElement> noAdditionalProgrammingElements, Set<ProgrammingElement> inProgrammingElements, Set<ProgrammingElement> outProgrammingElements, Set<ProgrammingElement> inOutProgrammingElements, Set<ProgrammingElement> removedProgrammingElements, Set<ParserDependency> removedParserDependencies, Set<ParserDependency> addedParserDependencies) {
        assert (noAdditionalProgrammingElements != null) : "Parameter 'noAdditionalProgrammingElements' of method 'ExplorationViewFocus' must not be null";
        assert (inProgrammingElements != null) : "Parameter 'inProgrammingElements' of method 'ExplorationViewFocus' must not be null";
        assert (outProgrammingElements != null) : "Parameter 'outProgrammingElements' of method 'ExplorationViewFocus' must not be null";
        assert (inOutProgrammingElements != null) : "Parameter 'inOutProgrammingElements' of method 'ExplorationViewFocus' must not be null";
        assert (removedProgrammingElements != null) : "Parameter 'removedProgrammingElements' of method 'ExplorationViewFocus' must not be null";
        assert (removedParserDependencies != null) : "Parameter 'removedParserDependencies' of method 'ExplorationViewFocus' must not be null";
        assert (addedParserDependencies != null) : "Parameter 'addedParserDependencies' of method 'ExplorationViewFocus' must not be null";
        this.m_noAdditionalProgrammingElements.addAll(noAdditionalProgrammingElements);
        this.m_inProgrammingElements.addAll(inProgrammingElements);
        this.m_outProgrammingElements.addAll(outProgrammingElements);
        this.m_inOutProgrammingElements.addAll(inOutProgrammingElements);
        this.m_removedProgrammingElements.addAll(removedProgrammingElements);
        this.m_removedParserDependencies.addAll(removedParserDependencies);
        this.m_addedParserDependencies.addAll(addedParserDependencies);
    }

    public void setDescriptorCache(DescriptorCache descriptorCache) {
        assert (this.m_descriptorCache == null) : "'m_descriptorCache' of method 'setDescriptorCache' must be null";
        assert (descriptorCache != null) : "Parameter 'descriptorCache' of method 'setDescriptorCache' must not be null";
        this.m_descriptorCache = descriptorCache;
    }

    private boolean hasInOutProgrammingElements() {
        return !this.m_inProgrammingElements.isEmpty() || !this.m_outProgrammingElements.isEmpty() || !this.m_inOutProgrammingElements.isEmpty();
    }

    public DescriptorCache consumeDescriptorCache() {
        DescriptorCache descriptorCache = this.m_descriptorCache;
        this.m_descriptorCache = null;
        return descriptorCache;
    }

    public void addFrom(ExplorationViewFocus other) {
        assert (other != null) : "Parameter 'other' of method 'addFrom' must not be null";
        this.m_noAdditionalProgrammingElements.addAll(other.m_noAdditionalProgrammingElements);
        this.m_inProgrammingElements.addAll(other.m_inProgrammingElements);
        this.m_outProgrammingElements.addAll(other.m_outProgrammingElements);
        this.m_inOutProgrammingElements.addAll(other.m_inOutProgrammingElements);
        this.m_removedProgrammingElements.addAll(other.m_removedProgrammingElements);
        this.m_addedParserDependencies.addAll(other.m_addedParserDependencies);
        this.m_removedParserDependencies.addAll(other.m_removedParserDependencies);
        if (other.m_descriptorCache != null) {
            this.m_descriptorCache = other.m_descriptorCache;
        }
    }

    public ExplorationViewFocus copy() {
        ExplorationViewFocus copy = new ExplorationViewFocus();
        copy.addFrom(this);
        return copy;
    }

    public void addProgrammingElements(Collection<ProgrammingElement> add, Mode mode) {
        assert (add != null) : "Parameter 'add' of method 'addProgrammingElements' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'addProgrammingElements' must not be null";
        this.m_removedProgrammingElements.removeAll(add);
        switch (mode) {
            case NO_ADDITIONAL: {
                this.m_noAdditionalProgrammingElements.addAll(add);
                break;
            }
            case IN: {
                this.m_inProgrammingElements.addAll(add);
                break;
            }
            case OUT: {
                this.m_outProgrammingElements.addAll(add);
                break;
            }
            case IN_OUT: {
                this.m_inOutProgrammingElements.addAll(add);
                break;
            }
            default: {
                assert (false) : "Unhandled mode: " + (Object)((Object)mode);
                break;
            }
        }
    }

    public void removeProgrammingElements(Collection<ProgrammingElement> remove) {
        ProgrammingElement nextTo;
        ProgrammingElement nextFrom;
        ParserDependency nextParserDependency;
        Iterator<ParserDependency> iter;
        assert (remove != null) : "Parameter 'remove' of method 'removeProgrammingElements' must not be null";
        this.m_noAdditionalProgrammingElements.removeAll(remove);
        this.m_inProgrammingElements.removeAll(remove);
        this.m_outProgrammingElements.removeAll(remove);
        this.m_inOutProgrammingElements.removeAll(remove);
        if (this.hasInOutProgrammingElements()) {
            this.m_removedProgrammingElements.addAll(remove);
        }
        if (!this.m_removedParserDependencies.isEmpty()) {
            iter = this.m_removedParserDependencies.iterator();
            block0: while (iter.hasNext()) {
                nextParserDependency = iter.next();
                nextFrom = nextParserDependency.getFrom();
                nextTo = nextParserDependency.getTo();
                for (ProgrammingElement next : remove) {
                    if (nextFrom != next && nextTo != next) continue;
                    iter.remove();
                    continue block0;
                }
            }
        }
        if (!this.m_addedParserDependencies.isEmpty()) {
            iter = this.m_addedParserDependencies.iterator();
            block2: while (iter.hasNext()) {
                nextParserDependency = iter.next();
                nextFrom = nextParserDependency.getFrom();
                nextTo = nextParserDependency.getTo();
                for (ProgrammingElement next : remove) {
                    if (nextFrom != next && nextTo != next) continue;
                    iter.remove();
                    continue block2;
                }
            }
        }
    }

    public boolean includesProgrammingElement(ProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'includesProgrammingElement' must not be null";
        return !this.m_removedProgrammingElements.contains(element) && this.m_noAdditionalProgrammingElements.contains(element) || this.m_inProgrammingElements.contains(element) || this.m_outProgrammingElements.contains(element) || this.m_inOutProgrammingElements.contains(element);
    }

    public void aboutToApply() {
        assert (!this.m_inApply) : "'!m_inApply' of method 'aboutToApply' already set";
        this.m_inApply = true;
        this.m_internalAssignableToArtifactNodesRemovedByFocus = 0;
        this.m_externalAssignableToArtifactNodesRemovedByFocus = 0;
    }

    public void nodeRemovedByFocus(AssignableToArtifactNode node) {
        assert (node != null) : "Parameter 'node' of method 'nodeRemovedByFocus' must not be null";
        if (node.isExternal()) {
            ++this.m_externalAssignableToArtifactNodesRemovedByFocus;
        } else {
            ++this.m_internalAssignableToArtifactNodesRemovedByFocus;
        }
    }

    public void applyFinished() {
        assert (this.m_inApply) : "'!m_inApply' of method 'aboutToApply' not set";
        this.m_inApply = false;
    }

    public Set<ProgrammingElement> getProgrammingElements(Mode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'getProgrammingElements' must not be null";
        switch (mode) {
            case NO_ADDITIONAL: {
                return Collections.unmodifiableSet(this.m_noAdditionalProgrammingElements);
            }
            case IN: {
                return Collections.unmodifiableSet(this.m_inProgrammingElements);
            }
            case OUT: {
                return Collections.unmodifiableSet(this.m_outProgrammingElements);
            }
            case IN_OUT: {
                return Collections.unmodifiableSet(this.m_inOutProgrammingElements);
            }
        }
        assert (false) : "Unhandled mode: " + (Object)((Object)mode);
        return Collections.emptySet();
    }

    public Set<ProgrammingElement> getRemovedProgrammingElements() {
        return Collections.unmodifiableSet(this.m_removedProgrammingElements);
    }

    public void addParserDependency(ParserDependency add) {
        assert (add != null) : "Parameter 'add' of method 'addParserDependency' must not be null";
        this.m_removedParserDependencies.remove(add);
        this.m_addedParserDependencies.add(add);
    }

    public void removeParserDependency(ParserDependency remove) {
        assert (remove != null) : "Parameter 'remove' of method 'removeParserDependency' must not be null";
        this.m_addedParserDependencies.remove(remove);
        this.m_removedParserDependencies.add(remove);
    }

    public boolean includesParserDependency(ParserDependency dependency, ProgrammingElement from, ProgrammingElement to) {
        assert (dependency != null) : "Parameter 'dependency' of method 'includesParserDependency' must not be null";
        assert (from != null) : "Parameter 'from' of method 'includesParserDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'includesParserDependency' must not be null";
        if (this.m_removedProgrammingElements.contains(from) || this.m_removedProgrammingElements.contains(to)) {
            return false;
        }
        if (this.m_removedParserDependencies.contains(dependency)) {
            return false;
        }
        if (this.m_addedParserDependencies.contains(dependency)) {
            return true;
        }
        if (this.m_outProgrammingElements.contains(from)) {
            return true;
        }
        if (this.m_inOutProgrammingElements.contains(from)) {
            return true;
        }
        if (this.m_inProgrammingElements.contains(to)) {
            return true;
        }
        if (this.m_inOutProgrammingElements.contains(to)) {
            return true;
        }
        return this.m_noAdditionalProgrammingElements.contains(from) && this.m_noAdditionalProgrammingElements.contains(to);
    }

    public Set<ParserDependency> getAddedParserDependencies() {
        return Collections.unmodifiableSet(this.m_addedParserDependencies);
    }

    public Set<ParserDependency> getRemovedParserDependencies() {
        return Collections.unmodifiableSet(this.m_removedParserDependencies);
    }

    public void deleted(Set<ProgrammingElement> deletedProgrammingElements, Set<ParserDependency> deletedParserDependencies) {
        assert (deletedProgrammingElements != null) : "Parameter 'deletedProgrammingElements' of method 'deleted' must not be null";
        assert (deletedParserDependencies != null) : "Parameter 'deletedParserDependencies' of method 'deleted' must not be null";
        if (!deletedProgrammingElements.isEmpty()) {
            this.m_noAdditionalProgrammingElements.removeAll(deletedProgrammingElements);
            this.m_inProgrammingElements.removeAll(deletedProgrammingElements);
            this.m_outProgrammingElements.removeAll(deletedProgrammingElements);
            this.m_inOutProgrammingElements.removeAll(deletedProgrammingElements);
            this.m_removedProgrammingElements.removeAll(deletedProgrammingElements);
            for (ProgrammingElement next : deletedProgrammingElements) {
                this.m_addedParserDependencies.removeAll(next.getDependencies());
                this.m_removedParserDependencies.removeAll(next.getDependencies());
            }
        }
        if (!deletedParserDependencies.isEmpty()) {
            this.m_addedParserDependencies.removeAll(deletedParserDependencies);
            this.m_removedParserDependencies.removeAll(deletedParserDependencies);
        }
    }

    public boolean isEmpty() {
        return this.m_noAdditionalProgrammingElements.isEmpty() && this.m_inProgrammingElements.isEmpty() && this.m_outProgrammingElements.isEmpty() && this.m_inOutProgrammingElements.isEmpty() && this.m_removedProgrammingElements.isEmpty() && this.m_addedParserDependencies.isEmpty() && this.m_removedParserDependencies.isEmpty();
    }

    static String getParserDependenciesViolatingInfo(int violations, int ignoredViolations, int parserDependencies) {
        assert (violations >= 0) : "'violations' must not be negative";
        assert (ignoredViolations >= 0) : "'ignoredViolations' must not be negative";
        assert (parserDependencies >= 0) : "'parserDependencies' must not be negative";
        float percentageViolations = NumberUtility.getPercentageWithoutRounding((int)violations, (int)parserDependencies);
        float percentageIgnoredViolations = NumberUtility.getPercentageWithoutRounding((int)ignoredViolations, (int)parserDependencies);
        StringBuilder builder = new StringBuilder();
        builder.append(FORMAT.format(violations)).append(" (").append(FORMAT.format(NumberUtility.round((double)percentageViolations, (int)100000))).append("%) and ").append(FORMAT.format(ignoredViolations)).append(" ignored (").append(FORMAT.format(NumberUtility.round((double)percentageIgnoredViolations, (int)100000))).append("%)");
        return builder.toString();
    }

    public String getInfo(Set<ParserDependency> violating, Set<ParserDependency> ignoreViolating, int parserDependencies, String assignableToArtifactKind, int internalAssignableToArtifactNodes, int externalAssignableToArtifactNodes) {
        assert (violating != null) : "Parameter 'violating' of method 'getInfo' must not be null";
        assert (ignoreViolating != null) : "Parameter 'ignoreViolating' of method 'getInfo' must not be null";
        assert (assignableToArtifactKind != null) : "Parameter 'assignableToArtifactKind' of method 'getInfo' must not be null";
        assert (assignableToArtifactKind.length() > 0) : "'assignableToArtifactKind' of method 'getInfo' must not be empty";
        if (this.m_inApply) {
            return "";
        }
        if (this.isEmpty()) {
            return "None";
        }
        StringBuilder builder = new StringBuilder();
        int internal = internalAssignableToArtifactNodes - this.m_internalAssignableToArtifactNodesRemovedByFocus;
        int external = externalAssignableToArtifactNodes - this.m_externalAssignableToArtifactNodesRemovedByFocus;
        float percentageInternal = NumberUtility.getPercentageWithoutRounding((int)internal, (int)internalAssignableToArtifactNodes);
        String percentageInternalInfo = "(" + FORMAT.format(NumberUtility.round((double)percentageInternal, (int)100000)) + "%)";
        float percentageExternal = NumberUtility.getPercentageWithoutRounding((int)external, (int)externalAssignableToArtifactNodes);
        String percentageExternalInfo = "(" + FORMAT.format(NumberUtility.round((double)percentageExternal, (int)100000)) + "%)";
        builder.append(StringUtility.firstCharacterCase((String)assignableToArtifactKind, (boolean)false)).append("s: ");
        builder.append(FORMAT.format(internal)).append(" internal ").append(percentageInternalInfo).append(" and ").append(FORMAT.format(external)).append(" external ").append(percentageExternalInfo);
        if (!violating.isEmpty()) {
            int violations = 0;
            int ignoredViolations = 0;
            for (ParserDependency next : violating) {
                if (!this.includesParserDependency(next, next.getFrom(), next.getTo())) continue;
                if (ignoreViolating.contains(next)) {
                    ++ignoredViolations;
                    continue;
                }
                ++violations;
            }
            builder.append("\nParser dependencies violating: ").append(ExplorationViewFocus.getParserDependenciesViolatingInfo(violations, ignoredViolations, parserDependencies));
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.getClass().getSimpleName()).append("]");
        builder.append("\n'No Additional' Programming Elements (").append(this.m_noAdditionalProgrammingElements.size()).append(")");
        builder.append("\n'In' Programming Elements (").append(this.m_inProgrammingElements.size()).append(")");
        builder.append("\n'Out' Programming Elements (").append(this.m_outProgrammingElements.size()).append(")");
        builder.append("\n'In/Out' Programming Elements (").append(this.m_inOutProgrammingElements.size()).append(")");
        builder.append("\n'Removed' Programming Elements (").append(this.m_removedProgrammingElements.size()).append(")");
        builder.append("\n'Removed' Parser Dependencies (").append(this.m_removedParserDependencies.size()).append(")");
        builder.append("\n'Added' Parser Dependencies (").append(this.m_addedParserDependencies.size()).append(")");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_noAdditionalProgrammingElements.hashCode();
        result = 31 * result + this.m_inProgrammingElements.hashCode();
        result = 31 * result + this.m_outProgrammingElements.hashCode();
        result = 31 * result + this.m_inOutProgrammingElements.hashCode();
        result = 31 * result + this.m_removedProgrammingElements.hashCode();
        result = 31 * result + this.m_removedParserDependencies.hashCode();
        result = 31 * result + this.m_addedParserDependencies.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExplorationViewFocus other = (ExplorationViewFocus)obj;
        return this.m_noAdditionalProgrammingElements.equals(other.m_noAdditionalProgrammingElements) && this.m_inProgrammingElements.equals(other.m_inProgrammingElements) && this.m_outProgrammingElements.equals(other.m_outProgrammingElements) && this.m_inOutProgrammingElements.equals(other.m_inOutProgrammingElements) && this.m_removedProgrammingElements.equals(other.m_removedProgrammingElements) && this.m_removedParserDependencies.equals(other.m_removedParserDependencies) && this.m_addedParserDependencies.equals(other.m_addedParserDependencies);
    }

    public static enum Mode {
        NO_ADDITIONAL(false, false),
        IN(true, false),
        OUT(false, true),
        IN_OUT(true, true);

        private final boolean m_in;
        private final boolean m_out;

        private Mode(boolean in, boolean out) {
            this.m_in = in;
            this.m_out = out;
        }

        public boolean includeIn() {
            return this.m_in;
        }

        public boolean includeOut() {
            return this.m_out;
        }
    }
}

