/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class ExpandToAssignableToArtifactLevelRequest {
    private final ExplorationViewRepresentation m_representation;
    private final Set<AssignableToArtifactNode> m_expandTo;
    private final Set<AssignableToArtifactNode> m_nodeBased;
    private final Set<AssignableToArtifactNode> m_dependencyBased;

    public ExpandToAssignableToArtifactLevelRequest(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'ExpandToAssignableToArtifactLevelRequest' must not be null";
        this.m_representation = representation;
        this.m_expandTo = Collections.emptySet();
        this.m_nodeBased = Collections.emptySet();
        this.m_dependencyBased = Collections.emptySet();
    }

    public ExpandToAssignableToArtifactLevelRequest(ExplorationViewRepresentation representation, Set<AssignableToArtifactNode> nodeBased, Set<AssignableToArtifactNode> dependencyBased) {
        assert (representation != null) : "Parameter 'representation' of method 'ExpandToAssignableToArtifactLevelRequest' must not be null";
        assert (nodeBased != null) : "Parameter 'nodeBased' of method 'ExpandToAssignableToArtifactLevelRequest' must not be null";
        assert (dependencyBased != null) : "Parameter 'dependencyBased' of method 'ExpandToAssignableToArtifactLevelRequest' must not be null";
        assert (!nodeBased.isEmpty() || !dependencyBased.isEmpty()) : "Nothing to expand to";
        this.m_representation = representation;
        this.m_expandTo = new LinkedHashSet<AssignableToArtifactNode>(nodeBased);
        this.m_expandTo.addAll(dependencyBased);
        this.m_nodeBased = nodeBased;
        this.m_dependencyBased = dependencyBased;
    }

    public ExplorationViewRepresentation getRepresentation() {
        return this.m_representation;
    }

    public Set<AssignableToArtifactNode> getExpandTo() {
        return Collections.unmodifiableSet(this.m_expandTo);
    }

    public Set<AssignableToArtifactNode> getNodeBased() {
        assert (this.m_nodeBased != null) : "'m_nodeBased' of method 'getNodeBased' must not be null";
        return this.m_nodeBased;
    }

    public Set<AssignableToArtifactNode> getDependencyBased() {
        assert (this.m_dependencyBased != null) : "'m_dependencyBased' of method 'getDependencyBased' must not be null";
        return this.m_dependencyBased;
    }
}

