/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactPropertiesOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewOperationExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class EditArtifactsOperation
extends ArtifactPropertiesOperation {
    final List<String> m_artifacts;

    public EditArtifactsOperation(NamedElement parent, PresentationMode presentationMode, String targetParent, int targetPos, ArtifactProperties properties, List<String> artifacts) {
        super(parent, presentationMode, targetParent, targetPos, properties);
        assert (artifacts != null && !artifacts.isEmpty()) : "Parameter 'artifacts' of method 'EditArtifactsOperation' must not be empty";
        this.m_artifacts = new ArrayList<String>(artifacts);
    }

    private EditArtifactsOperation(NamedElement parent, EditArtifactsOperation copyOf) {
        super(parent, copyOf);
        assert (copyOf != null) : "Parameter 'copyOf' of method 'EditArtifactsOperation' must not be null";
        this.m_artifacts = new ArrayList<String>(copyOf.m_artifacts);
    }

    @Override
    public ArchitecturalViewOperation copy(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'copy' must not be null";
        return new EditArtifactsOperation(parent, this);
    }

    @Override
    public String getShortName() {
        return "Edit artifacts";
    }

    public List<String> getArtifacts() {
        return Collections.unmodifiableList(this.m_artifacts);
    }

    @Override
    public String getInformation() {
        return String.valueOf(super.getInformation()) + " Edit " + this.m_artifacts.size() + " artifact" + (this.m_artifacts.size() > 1 ? "s" : "");
    }

    @Override
    public void apply(IArchitecturalViewOperationExecutor executor) {
        assert (executor != null) : "Parameter 'executor' of method 'apply' must not be null";
        executor.editArtifacts(this, this.getTargetParent(), this.getTargetPos(), this.getArtifactProperties(), this.m_artifacts);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        for (String next : this.m_artifacts) {
            builder.append("\n");
            builder.append("Edit artifact: ").append(next);
        }
        return builder.toString();
    }
}

