/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.DeleteElementsOperationType;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewOperationExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DeleteElementsOperation
extends ArchitecturalViewOperation {
    private final List<String> m_elements;
    private DeleteElementsOperationType m_type;

    public DeleteElementsOperation(NamedElement parent, PresentationMode presentationMode, List<String> elements) {
        super(parent, presentationMode);
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'DeleteElementsOperation' must not be empty";
        this.m_elements = new ArrayList<String>(elements);
    }

    public DeleteElementsOperation(NamedElement parent, PresentationMode presentationMode, List<String> elements, DeleteElementsOperationType type) {
        this(parent, presentationMode, elements);
        assert (type != null) : "Parameter 'type' of method 'DeleteElementsOperation' must not be null";
        this.m_type = type;
    }

    private DeleteElementsOperation(NamedElement parent, DeleteElementsOperation copyOf) {
        super(parent, copyOf);
        assert (copyOf != null) : "Parameter 'copyOf' of method 'DeleteElementsOperation' must not be null";
        this.m_elements = new ArrayList<String>(copyOf.m_elements);
    }

    @Override
    public ArchitecturalViewOperation copy(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'copy' must not be null";
        return new DeleteElementsOperation(parent, this);
    }

    @Override
    public String getImageResourceName() {
        return "Delete";
    }

    @Override
    public String getShortName() {
        return "Delete elements";
    }

    public List<String> getElements() {
        return Collections.unmodifiableList(this.m_elements);
    }

    @Override
    public String getInformation() {
        return String.valueOf(super.getInformation()) + " Delete " + (this.m_type != null && this.m_type == DeleteElementsOperationType.DELETE_REFACTORING ? "(refactoring) " : "") + this.m_elements.size() + " element" + (this.m_elements.size() > 1 ? "s" : "");
    }

    @Property
    public List<String> getInformationDeletedElement() {
        return Collections.unmodifiableList(this.m_elements);
    }

    @Override
    public void apply(IArchitecturalViewOperationExecutor executor) {
        DeleteElementsOperationType type;
        assert (executor != null) : "Parameter 'executor' of method 'apply' must not be null";
        this.m_type = type = executor.deleteElements(this, this.m_elements);
    }

    @Override
    public void reset() {
        this.m_type = null;
        super.reset();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        for (String next : this.m_elements) {
            builder.append("\n");
            builder.append("Delete element: ").append(next);
        }
        return builder.toString();
    }
}

