/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewOperationExecutor;
import com.hello2morrow.sonargraph.core.model.explorationview.TargetParentOperation;
import com.hello2morrow.sonargraph.core.model.refactoring.RecursiveElementRefactoringDescriptor;

public final class CreateElementOperation
extends TargetParentOperation {
    private final RecursiveElementRefactoringDescriptor.ElementType m_type;
    private final String m_elementName;
    private RecursiveElementRefactoringDescriptor m_descriptor;

    public CreateElementOperation(NamedElement parent, PresentationMode presentationMode, String targetParent, int targetPos, RecursiveElementRefactoringDescriptor.ElementType type, String name) {
        super(parent, presentationMode, targetParent, targetPos);
        assert (type != null) : "Parameter 'type' of method 'CreateElementOperation' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'CreateElementOperation' must not be empty";
        this.m_type = type;
        this.m_elementName = name;
    }

    public CreateElementOperation(NamedElement parent, PresentationMode presentationMode, String targetParent, int targetPos, RecursiveElementRefactoringDescriptor.ElementType type, String name, RecursiveElementRefactoringDescriptor descriptor) {
        this(parent, presentationMode, targetParent, targetPos, type, name);
        assert (descriptor != null) : "Parameter 'descriptor' of method 'CreateElementOperation' must not be null";
        this.m_descriptor = descriptor;
    }

    private CreateElementOperation(NamedElement parent, CreateElementOperation copyOf) {
        super(parent, copyOf);
        assert (copyOf != null) : "Parameter 'copyOf' of method 'CreateElementOperation' must not be null";
        this.m_type = copyOf.m_type;
        this.m_elementName = copyOf.m_elementName;
    }

    @Override
    public boolean containsRefactoring() {
        return true;
    }

    @Override
    public ArchitecturalViewOperation copy(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'copy' must not be null";
        return new CreateElementOperation(parent, this);
    }

    @Override
    public String getImageResourceName() {
        return "CreateElement";
    }

    @Override
    public String getShortName() {
        return "Create element";
    }

    public RecursiveElementRefactoringDescriptor.ElementType getType() {
        return this.m_type;
    }

    public String getElementName() {
        return this.m_elementName;
    }

    @Override
    public String getInformation() {
        String targetParent = this.getTargetParentPresentationName();
        int targetPos = this.getTargetPos();
        if (this.m_descriptor == null) {
            return String.valueOf(super.getInformation()) + " Create " + this.m_type.getPresentationName() + " element '" + this.m_elementName + "'" + (targetParent.isEmpty() ? "" : " underneath '" + this.getTargetParentPresentationName() + "'") + (targetPos != -1 ? " at pos: " + targetPos : "");
        }
        return String.valueOf(super.getInformation()) + " Create " + this.m_descriptor.getLanguage().getPresentationName() + " " + this.m_descriptor.getPresentationName() + " '" + this.m_elementName + "'" + (targetParent.isEmpty() ? "" : " underneath '" + this.getTargetParentPresentationName() + "'") + (targetPos != -1 ? " at pos: " + targetPos : "");
    }

    @Override
    public void reset() {
        this.m_descriptor = null;
        super.reset();
    }

    @Override
    public void apply(IArchitecturalViewOperationExecutor executor) {
        assert (executor != null) : "Parameter 'executor' of method 'apply' must not be null";
        this.m_descriptor = executor.createElement(this, this.getTargetParent(), this.getTargetPos(), this.m_type, this.m_elementName);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("\n");
        builder.append("[").append((Object)this.m_type).append("] ").append(this.m_elementName);
        return builder.toString();
    }
}

