/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactPropertiesOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewOperationExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CreateArtifactsForElementsOperation
extends ArtifactPropertiesOperation {
    private final List<String> m_forElements;

    public CreateArtifactsForElementsOperation(NamedElement parent, PresentationMode presentationMode, String targetParent, int targetPos, ArtifactProperties properties, List<String> forElements) {
        super(parent, presentationMode, targetParent, targetPos, properties);
        assert (forElements != null && !forElements.isEmpty()) : "Parameter 'forElements' of method 'CreateArtifactsForElementsOperation' must not be empty";
        this.m_forElements = new ArrayList<String>(forElements);
    }

    private CreateArtifactsForElementsOperation(NamedElement parent, CreateArtifactsForElementsOperation copyOf) {
        super(parent, copyOf);
        assert (copyOf != null) : "Parameter 'copyOf' of method 'CreateArtifactsForElementsOperation' must not be null";
        this.m_forElements = new ArrayList<String>(copyOf.m_forElements);
    }

    @Override
    public ArchitecturalViewOperation copy(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'copy' must not be null";
        return new CreateArtifactsForElementsOperation(parent, this);
    }

    @Override
    public String getShortName() {
        return "Create artifacts for elements";
    }

    @Override
    public String getInformation() {
        String targetParent = this.getTargetParentPresentationName();
        int targetPos = this.getTargetPos();
        return String.valueOf(super.getInformation()) + " For " + this.m_forElements.size() + " element" + (this.m_forElements.size() > 1 ? "s" : "") + (targetParent.isEmpty() ? "" : "' underneath '" + targetParent + "'") + (targetPos == -1 ? "" : " at position " + targetPos);
    }

    @Property
    public List<String> getInformationForElement() {
        return Collections.unmodifiableList(this.m_forElements);
    }

    public List<String> getForElements() {
        return Collections.unmodifiableList(this.m_forElements);
    }

    @Override
    public void apply(IArchitecturalViewOperationExecutor executor) {
        assert (executor != null) : "Parameter 'executor' of method 'apply' must not be null";
        executor.createArtifactsForElements(this, this.getTargetParent(), this.getTargetPos(), this.getArtifactProperties(), this.m_forElements);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("\n");
        builder.append(ArtifactPropertiesOperation.getInfo("element", this.m_forElements));
        return builder.toString();
    }
}

