/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNameOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewOperationExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CreateArtifactFromElementsOperation
extends ArtifactNameOperation {
    private final List<String> m_fromElements;

    public CreateArtifactFromElementsOperation(NamedElement parent, PresentationMode presentationMode, String targetParent, int targetPos, ArtifactProperties properties, String artifactName, List<String> fromElements) {
        super(parent, presentationMode, targetParent, targetPos, properties, artifactName);
        assert (fromElements != null && !fromElements.isEmpty()) : "Parameter 'fromElements' of method 'CreateArtifactFromElementsOperation' must not be empty";
        this.m_fromElements = new ArrayList<String>(fromElements);
    }

    private CreateArtifactFromElementsOperation(NamedElement parent, CreateArtifactFromElementsOperation copyOf) {
        super(parent, copyOf);
        assert (copyOf != null) : "Parameter 'copyOf' of method 'CreateArtifactFromElementsOperation' must not be null";
        this.m_fromElements = new ArrayList<String>(copyOf.m_fromElements);
    }

    @Override
    public ArchitecturalViewOperation copy(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'copy' must not be null";
        return new CreateArtifactFromElementsOperation(parent, this);
    }

    @Override
    public String getShortName() {
        return "Create artifact from elements";
    }

    @Override
    public String getInformation() {
        String targetParent = this.getTargetParentPresentationName();
        int targetPos = this.getTargetPos();
        return String.valueOf(super.getInformation()) + " '" + this.getArtifactName() + "'" + (targetParent.isEmpty() ? "" : " underneath '" + targetParent + "'") + (targetPos == -1 ? "" : " at position " + targetPos) + " from " + this.m_fromElements.size() + " element" + (this.m_fromElements.size() > 1 ? "s" : "");
    }

    @Property
    public List<String> getInformationFromElement() {
        return Collections.unmodifiableList(this.m_fromElements);
    }

    public List<String> getFromElements() {
        return Collections.unmodifiableList(this.m_fromElements);
    }

    @Override
    public void apply(IArchitecturalViewOperationExecutor executor) {
        assert (executor != null) : "Parameter 'executor' of method 'apply' must not be null";
        executor.createArtifactFromElements(this, this.getTargetParent(), this.getTargetPos(), this.getArtifactProperties(), this.getArtifactName(), this.m_fromElements);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("\n");
        builder.append(ArtifactNameOperation.getInfo("element", this.m_fromElements));
        return builder.toString();
    }
}

