/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactAssignmentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactIncomingDependencyMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactOutgoingDependencyMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactVisibility;
import java.util.EnumSet;

public final class ArtifactProperties {
    private final ArtifactIncomingDependencyMode m_incomingDependencyMode;
    private final ArtifactOutgoingDependencyMode m_outgoingDependencyMode;
    private final ArtifactAssignmentMode m_assignmentMode;
    private final EnumSet<ArtifactVisibility> m_visibility;

    public ArtifactProperties(ArtifactIncomingDependencyMode incomingDependencyMode, ArtifactOutgoingDependencyMode outgoingDependencyMode, ArtifactAssignmentMode assignmentMode, EnumSet<ArtifactVisibility> visibility) {
        assert (incomingDependencyMode != null) : "Parameter 'incomingDependencyMode' of method 'ArtifactProperties' must not be null";
        assert (outgoingDependencyMode != null) : "Parameter 'outgoingDependencyMode' of method 'ArtifactProperties' must not be null";
        assert (assignmentMode != null) : "Parameter 'assignmentMode' of method 'ArtifactProperties' must not be null";
        assert (visibility != null) : "Parameter 'visibility' of method 'ArtifactProperties' must not be null";
        this.m_incomingDependencyMode = incomingDependencyMode;
        this.m_outgoingDependencyMode = outgoingDependencyMode;
        this.m_assignmentMode = assignmentMode;
        this.m_visibility = EnumSet.copyOf(visibility);
    }

    public ArtifactProperties addVisibility(ArtifactVisibility add) {
        assert (add != null) : "Parameter 'add' of method 'addVisibility' must not be null";
        EnumSet<ArtifactVisibility> visibility = EnumSet.copyOf(this.m_visibility);
        visibility.add(add);
        return new ArtifactProperties(this.m_incomingDependencyMode, this.m_outgoingDependencyMode, this.m_assignmentMode, visibility);
    }

    public ArtifactProperties removeVisibility(ArtifactVisibility remove) {
        assert (remove != null) : "Parameter 'remove' of method 'removeVisibility' must not be null";
        EnumSet<ArtifactVisibility> visibility = EnumSet.copyOf(this.m_visibility);
        visibility.remove(remove);
        return new ArtifactProperties(this.m_incomingDependencyMode, this.m_outgoingDependencyMode, this.m_assignmentMode, visibility);
    }

    public ArtifactProperties clearVisibility() {
        return new ArtifactProperties(this.m_incomingDependencyMode, this.m_outgoingDependencyMode, this.m_assignmentMode, EnumSet.noneOf(ArtifactVisibility.class));
    }

    public ArtifactProperties setIncomingDependencyMode(ArtifactIncomingDependencyMode in) {
        assert (in != null) : "Parameter 'in' of method 'setIncomingDependencyMode' must not be null";
        return new ArtifactProperties(in, this.m_outgoingDependencyMode, this.m_assignmentMode, this.m_visibility);
    }

    public ArtifactProperties setOutgoingDependencyMode(ArtifactOutgoingDependencyMode out) {
        assert (out != null) : "Parameter 'out' of method 'setOutgoingDependencyMode' must not be null";
        return new ArtifactProperties(this.m_incomingDependencyMode, out, this.m_assignmentMode, this.m_visibility);
    }

    public ArtifactProperties setAssignmentMode(ArtifactAssignmentMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'setAssignmentMode' must not be null";
        return new ArtifactProperties(this.m_incomingDependencyMode, this.m_outgoingDependencyMode, mode, this.m_visibility);
    }

    public EnumSet<ArtifactVisibility> getVisibility() {
        return this.m_visibility;
    }

    public ArtifactIncomingDependencyMode getIncomingDependencyMode() {
        return this.m_incomingDependencyMode;
    }

    public ArtifactOutgoingDependencyMode getOutgoingDependencyMode() {
        return this.m_outgoingDependencyMode;
    }

    public ArtifactAssignmentMode getAssignmentMode() {
        return this.m_assignmentMode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_incomingDependencyMode.hashCode();
        result = 31 * result + this.m_outgoingDependencyMode.hashCode();
        result = 31 * result + this.m_assignmentMode.hashCode();
        result = 31 * result + this.m_visibility.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactProperties other = (ArtifactProperties)obj;
        return this.m_incomingDependencyMode == other.m_incomingDependencyMode && this.m_outgoingDependencyMode == other.m_outgoingDependencyMode && this.m_assignmentMode == other.m_assignmentMode && this.m_visibility.equals(other.m_visibility);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Incoming dependency mode: ").append(this.m_incomingDependencyMode.getPresentationName()).append("\n");
        builder.append("Outgoing dependency mode: ").append(this.m_outgoingDependencyMode.getPresentationName()).append("\n");
        builder.append("Visibility:");
        if (this.m_visibility.isEmpty()) {
            builder.append(" <none>");
        } else {
            this.m_visibility.forEach(v2 -> {
                StringBuilder stringBuilder2 = builder.append(" ").append(v2.getPresentationName());
            });
        }
        return builder.toString();
    }
}

