/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFilter;
import com.hello2morrow.sonargraph.core.model.explorationview.PatternFilterExclude;
import com.hello2morrow.sonargraph.core.model.explorationview.PatternFilterInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class ArtifactNodeFilter
extends NamedElementContainer {
    private boolean m_isManual;

    public static final boolean areEqual(ArtifactNodeFilter filter1, ArtifactNodeFilter filter2) {
        assert (filter1 != null) : "Parameter 'filter1' of method 'areEqual' must not be null";
        assert (filter2 != null) : "Parameter 'filter2' of method 'areEqual' must not be null";
        List<ArchitecturalViewFilter> list1 = filter1.getChildren(ArchitecturalViewFilter.class);
        List<ArchitecturalViewFilter> list2 = filter2.getChildren(ArchitecturalViewFilter.class);
        if (list1.size() != list2.size()) {
            return false;
        }
        int i2 = 0;
        while (i2 < list1.size()) {
            if (!list1.get(i2).getName().equals(list2.get(i2).getName())) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static ArtifactNodeFilter createCopy(ArtifactNodeFilter filter, ArchitecturalViewFilter ... except) {
        ArchitecturalViewFilter nextExcept;
        int n2;
        int n3;
        ArchitecturalViewFilter[] architecturalViewFilterArray;
        boolean add;
        assert (filter != null) : "Parameter 'filter' of method 'createCopy' must not be null";
        ArtifactNodeFilter copy = new ArtifactNodeFilter(null);
        for (PatternFilterInclude nextInclude : filter.getChildren(PatternFilterInclude.class)) {
            add = true;
            architecturalViewFilterArray = except;
            n3 = except.length;
            n2 = 0;
            while (n2 < n3) {
                nextExcept = architecturalViewFilterArray[n2];
                if (nextExcept == nextInclude) {
                    add = false;
                    break;
                }
                ++n2;
            }
            if (!add) continue;
            copy.addChild(nextInclude.copyOf(copy));
        }
        for (PatternFilterExclude nextExclude : filter.getChildren(PatternFilterExclude.class)) {
            add = true;
            architecturalViewFilterArray = except;
            n3 = except.length;
            n2 = 0;
            while (n2 < n3) {
                nextExcept = architecturalViewFilterArray[n2];
                if (nextExcept == nextExclude) {
                    add = false;
                    break;
                }
                ++n2;
            }
            if (!add) continue;
            copy.addChild(nextExclude.copyOf(copy));
        }
        copy.m_isManual = filter.m_isManual;
        return copy;
    }

    public ArtifactNodeFilter(NamedElement parent) {
        super(parent);
    }

    public void setIsManual(boolean isManual) {
        this.m_isManual = isManual;
    }

    public boolean isManual() {
        return this.m_isManual;
    }

    @Override
    public String getShortName() {
        return "Filter";
    }

    @Override
    public String getImageResourceName() {
        return "Filter";
    }

    public boolean include(IWorkerContext workerContext, IAssignableToArtifact assignableToArtifact, Set<String> multipleAttributeInfoCollector) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'include' must not be null";
        assert (assignableToArtifact != null) : "Parameter 'assignableToArtifact' of method 'include' must not be null";
        boolean include = false;
        for (PatternFilterInclude nextInclude : this.getChildren(PatternFilterInclude.class)) {
            if (workerContext.hasBeenCanceled()) {
                return false;
            }
            if (!nextInclude.matches(workerContext, assignableToArtifact, "Include", multipleAttributeInfoCollector)) continue;
            include = true;
            break;
        }
        if (include) {
            for (PatternFilterExclude nextExclude : this.getChildren(PatternFilterExclude.class)) {
                if (workerContext.hasBeenCanceled()) {
                    return false;
                }
                if (!nextExclude.matches(workerContext, assignableToArtifact, "Exclude", multipleAttributeInfoCollector)) continue;
                include = false;
                break;
            }
        }
        return include;
    }

    public boolean explicitlyExcludedByManualPatterns(IAssignableToArtifact assignableToArtifact) {
        assert (assignableToArtifact != null) : "Parameter 'assignableToArtifact' of method 'explicitlyExcludedByManualPatterns' must not be null";
        for (PatternFilterExclude nextExclude : this.getChildren(PatternFilterExclude.class)) {
            if (!nextExclude.isManual() || !nextExclude.matches((IWorkerContext)DefaultWorkerContext.INSTANCE, assignableToArtifact)) continue;
            return true;
        }
        return false;
    }

    private boolean firstIncludesSecondPattern(String first, String second) {
        assert (first != null && first.length() > 0) : "Parameter 'first' of method 'firstIncludesSecondPattern' must not be empty";
        assert (second != null && second.length() > 0) : "Parameter 'second' of method 'firstIncludesSecondPattern' must not be empty";
        assert (!first.equals(second)) : "Same patterns";
        if (first.endsWith(".**") || first.endsWith("/**")) {
            String firstWithoutStarStar;
            String secondWithoutStars = null;
            if (second.endsWith(".**") || second.endsWith("/**")) {
                secondWithoutStars = first.substring(0, first.length() - 3);
            } else if (second.endsWith(".*") || second.endsWith("/*")) {
                secondWithoutStars = first.substring(0, first.length() - 2);
            }
            if (secondWithoutStars != null && secondWithoutStars.startsWith(firstWithoutStarStar = first.substring(0, first.length() - 3))) {
                return true;
            }
        }
        return false;
    }

    public boolean needsToBeAdded(String pattern, PatternKind kind) {
        assert (pattern != null && pattern.length() > 0) : "Parameter 'pattern' of method 'needsToBeAdded' must not be empty";
        assert (kind != null) : "Parameter 'kind' of method 'needsToBeAdded' must not be null";
        boolean add = true;
        block0 : switch (kind) {
            case EXCLUDE: {
                for (PatternFilterExclude nextExclude : this.getChildren(PatternFilterExclude.class)) {
                    String nextExcludePattern = nextExclude.getName();
                    if (nextExcludePattern.equals("**")) {
                        add = false;
                        break block0;
                    }
                    if (nextExcludePattern.equals(pattern)) {
                        add = false;
                        break block0;
                    }
                    if (!this.firstIncludesSecondPattern(nextExcludePattern, pattern)) continue;
                    add = false;
                    break block0;
                }
                break;
            }
            case INCLUDE: {
                for (PatternFilterInclude nextInclude : this.getChildren(PatternFilterInclude.class)) {
                    String nextIncludePattern = nextInclude.getName();
                    if (nextIncludePattern.equals("**")) {
                        add = false;
                        break block0;
                    }
                    if (nextIncludePattern.equals(pattern)) {
                        add = false;
                        break block0;
                    }
                    if (!this.firstIncludesSecondPattern(nextIncludePattern, pattern)) continue;
                    add = false;
                    break block0;
                }
                break;
            }
            default: {
                assert (false) : "Unhandled kind: " + (Object)((Object)kind);
                break;
            }
        }
        return add;
    }

    public boolean containsPattern(String pattern) {
        assert (pattern != null && pattern.length() > 0) : "Parameter 'pattern' of method 'containsPattern' must not be empty";
        for (PatternFilterInclude nextInclude : this.getChildren(PatternFilterInclude.class)) {
            if (!nextInclude.getName().equals(pattern)) continue;
            return true;
        }
        for (PatternFilterExclude nextExclude : this.getChildren(PatternFilterExclude.class)) {
            if (!nextExclude.getName().equals(pattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addChild(NamedElement child) {
        PatternFilterExclude firstExclude;
        assert (child != null && child instanceof ArchitecturalViewFilter) : "Unexpected class in method 'addChild': " + child;
        assert (!this.containsPattern(child.getName())) : "Pattern already added: " + child.getName();
        super.addChild(child);
        if (child instanceof PatternFilterInclude && (firstExclude = this.getFirstChild(PatternFilterExclude.class)) != null) {
            int index = this.getIndexOf(ArchitecturalViewFilter.class, firstExclude);
            this.moveChild(ArchitecturalViewFilter.class, child, index);
        }
    }

    public boolean hasIncludes() {
        return this.hasChildren(false, PatternFilterInclude.class);
    }

    public boolean hasExcludes() {
        return this.hasChildren(false, PatternFilterExclude.class);
    }

    public boolean isEmpty() {
        return !this.hasAllChildren(false, ArchitecturalViewFilter.class);
    }

    public void clear(boolean automaticOnly) {
        if (automaticOnly) {
            for (ArchitecturalViewFilter next : new ArrayList<ArchitecturalViewFilter>(this.getChildren(ArchitecturalViewFilter.class))) {
                if (next.isManual()) continue;
                this.removeChild(next);
            }
        } else {
            this.removeChildren(ArchitecturalViewFilter.class);
        }
    }

    public void reset() {
        this.getChildren(ArchitecturalViewFilter.class).forEach(p2 -> p2.reset());
    }

    @Property
    public String getFilterInfo() {
        List<PatternFilterInclude> includes = this.getChildren(PatternFilterInclude.class);
        List<PatternFilterExclude> excludes = this.getChildren(PatternFilterExclude.class);
        if (includes.isEmpty() && excludes.isEmpty()) {
            return "";
        }
        StringBuilder info = new StringBuilder();
        info.append(includes.size()).append(" include(s) ").append(excludes.size()).append(" exclude(s)");
        for (PatternFilterInclude nextInclude : includes) {
            info.append("\n");
            info.append(PatternKind.INCLUDE.getPresentationName()).append(": ").append(nextInclude.getName());
            if (nextInclude.isManual()) {
                info.append(" ").append("[+/-]");
            }
            info.append(" (matching ").append(nextInclude.getMatchingCount()).append(")");
        }
        for (PatternFilterExclude nextExclude : excludes) {
            info.append("\n");
            info.append(PatternKind.EXCLUDE.getPresentationName()).append(": ").append(nextExclude.getName());
            if (nextExclude.isManual()) {
                info.append(" ").append("[+/-]");
            }
            info.append(" (matching ").append(nextExclude.getMatchingCount()).append(")");
        }
        return info.toString();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitArtifactNodeFilter(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String toString() {
        String filterInfo = this.getFilterInfo();
        return String.valueOf(this.getClass().getSimpleName()) + (filterInfo.isEmpty() ? "" : "\n" + filterInfo);
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitArtifactNodeFilter(ArtifactNodeFilter var1);
    }

    public static enum PatternKind implements IStandardEnumeration
    {
        INCLUDE,
        EXCLUDE;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

