/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeFilter;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactPropertiesNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableNode;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ArtifactNode
extends ArtifactPropertiesNode
implements IAssignableTarget {
    public static final NamedElement.IFilter EXCLUDE_ARTIFACT_NODES = new NamedElement.IFilter(){

        @Override
        public boolean accept(NamedElement namedElement) {
            if (!($assertionsDisabled || namedElement != null && namedElement instanceof ArchitecturalViewNode)) {
                throw new AssertionError((Object)("Unexpected class in method 'accept': " + namedElement));
            }
            return !(namedElement instanceof ArtifactNode);
        }
    };
    static final String RELATIVE_PATH_PREFIX_ESCAPED = "A\\" + INNER_NAME_PARTS_SEPARATOR;
    private List<ArtifactNode> m_allowed;
    private String m_shortName;
    private boolean m_hasHiddenElements;

    public ArtifactNode(ArchitecturalViewElement parent, PresentationMode presentationMode, String shortName, ArtifactProperties properties, ArtifactNodeFilter filter) {
        super(parent, presentationMode, false, properties);
        assert (parent != null) : "Parameter 'parent' of method 'ArtifactNode' must not be null";
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'ArtifactNode' must not be empty";
        assert (properties != null) : "Parameter 'properties' of method 'ArtifactNode' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'ArtifactNode' must not be null";
        this.m_shortName = shortName;
        filter.setParent(this);
        this.addChild(filter);
    }

    @Override
    public int getRelativeIndexOffset() {
        return 1;
    }

    public ArtifactNodeFilter getFilter() {
        return this.getUniqueExistingChild(ArtifactNodeFilter.class);
    }

    public boolean hasManualFilter() {
        return this.getFilter().isManual();
    }

    @Property
    public String getFilterInfo() {
        return this.getFilter().getFilterInfo();
    }

    @Override
    public NamedElement getFirstUnderlyingElement() {
        return this;
    }

    @Override
    public String getPresentationKind() {
        return "Artifact";
    }

    @Override
    public List<NamedElement> getUnderlyingElements() {
        return Collections.singletonList(this);
    }

    public boolean setShortName(String shortName) {
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'setShortName' must not be empty";
        if (!this.m_shortName.equals(shortName)) {
            this.m_shortName = shortName;
            return true;
        }
        return false;
    }

    public void setHasHiddenElements(boolean hasHiddenElements) {
        this.m_hasHiddenElements = hasHiddenElements;
    }

    public boolean hasHiddenElements() {
        return this.m_hasHiddenElements;
    }

    public boolean isAllowed(ArtifactNode to) {
        assert (to != null) : "Parameter 'to' of method 'isAllowed' must not be null";
        return this.m_allowed != null ? this.m_allowed.contains(to) : false;
    }

    public void addAllowed(ArtifactNode to) {
        assert (to != null) : "Parameter 'to' of method 'addAllowed' must not be null";
        assert (this != to) : "Same instances";
        if (this.m_allowed == null) {
            this.m_allowed = new ArrayList<ArtifactNode>(2);
        }
        assert (!this.m_allowed.contains(to)) : "Already added as allowed: " + to;
        this.m_allowed.add(to);
    }

    public void removeAllowed(ArtifactNode to) {
        assert (to != null) : "Parameter 'to' of method 'removeAllowed' must not be null";
        assert (this.m_allowed != null && !this.m_allowed.isEmpty()) : "'m_allowed' of method 'removeAllowed' must not be empty";
        boolean removed = this.m_allowed.remove(to);
        assert (removed) : "Not found: " + to;
    }

    public List<ArtifactNode> getAllowed() {
        return this.m_allowed != null ? Collections.unmodifiableList(this.m_allowed) : Collections.emptyList();
    }

    @Property
    public List<String> getAllowedTargetArtifact() {
        if (this.m_allowed != null) {
            ArrayList<String> info = new ArrayList<String>(this.m_allowed.size());
            this.m_allowed.forEach(a2 -> {
                boolean bl2 = info.add(a2.getName());
            });
            return info;
        }
        return Collections.emptyList();
    }

    @Override
    public String getShortName() {
        return this.m_shortName;
    }

    @Override
    public String getPresentationName(boolean shortName) {
        return String.valueOf(super.getPresentationName(shortName)) + (this.hasManualFilter() ? " [+/-]" : "") + (this.m_allowed != null && !this.m_allowed.isEmpty() ? " [>" + this.m_allowed.size() + "]" : "");
    }

    public boolean hasAssignedElement(boolean recursively) {
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        if (children == null) {
            return false;
        }
        for (NamedElement nextChild : children) {
            if (!(nextChild instanceof AssignableNode)) continue;
            return true;
        }
        if (recursively) {
            for (NamedElement nextChild : children) {
                if (!(nextChild instanceof ArtifactNode) || !((ArtifactNode)nextChild).hasAssignedElement(recursively)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitArtifactNode(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String toString() {
        ArtifactNodeFilter filter = this.getFilter();
        return String.valueOf(super.toString()) + (filter.isEmpty() ? "" : "\n" + filter);
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitArtifactNode(ArtifactNode var1);
    }
}

