/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewDependencyDescriptor;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class ArchitecturalViewState {
    private final Map<ArchitecturalViewNode, String> m_expandedNodes = new LinkedHashMap<ArchitecturalViewNode, String>();
    private final Map<ArchitecturalViewNode, String> m_selectedNodes = new LinkedHashMap<ArchitecturalViewNode, String>();
    private final Set<String> m_selectedNodeRelPaths = new LinkedHashSet<String>();
    private final Map<StrictPair<ArchitecturalViewNode, ArchitecturalViewNode>, ArchitecturalViewDependencyDescriptor> m_selectedDependencies = new LinkedHashMap<StrictPair<ArchitecturalViewNode, ArchitecturalViewNode>, ArchitecturalViewDependencyDescriptor>();

    public ArchitecturalViewState() {
    }

    public ArchitecturalViewState(Set<ArchitecturalViewNode> selectNodes, Collection<String> selectNodeRelPaths) {
        assert (selectNodes != null) : "Parameter 'selectNodes' of method 'ArchitecturalViewState' must not be null";
        assert (selectNodeRelPaths != null) : "Parameter 'selectNodeRelPaths' of method 'ArchitecturalViewState' must not be null";
        for (ArchitecturalViewNode node : selectNodes) {
            String previous = this.m_selectedNodes.put(node, node.getRelativePath());
            assert (previous == null) : "'previous' of method 'process' must  be null";
        }
        this.m_selectedNodeRelPaths.addAll(selectNodeRelPaths);
    }

    public void process(ArchitecturalViewNode node) {
        String previous;
        assert (node != null) : "Parameter 'node' of method 'process' must not be null";
        assert (node.isVisible()) : "Node not visible: " + node.getElementInfo();
        if (node.isExpanded()) {
            previous = this.m_expandedNodes.put(node, node.getRelativePath());
            assert (previous == null) : "'previous' of method 'process' must  be null";
        }
        if (node.isSelected()) {
            previous = this.m_selectedNodes.put(node, node.getRelativePath());
            assert (previous == null) : "'previous' of method 'process' must  be null";
        }
        for (ArchitecturalViewNode.ArchitecturalViewDependency nextOut : node.getOutgoingDependencies()) {
            if (!nextOut.isSelected()) continue;
            this.m_selectedDependencies.put((StrictPair<ArchitecturalViewNode, ArchitecturalViewNode>)new StrictPair((Object)nextOut.getFrom(), (Object)nextOut.getTo()), new ArchitecturalViewDependencyDescriptor(nextOut.getFrom().getRelativePath(), true, nextOut.getTo().getRelativePath(), true, -1));
        }
    }

    public void addExpanded(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'addExpanded' must not be null";
        this.m_expandedNodes.put(node, node.getRelativePath());
    }

    public void addSelected(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'addSelected' must not be null";
        this.m_selectedNodes.put(node, node.getRelativePath());
    }

    public void addSelectedNodeRelPaths(String relPath) {
        assert (relPath != null && relPath.length() > 0) : "Parameter 'relPath' of method 'addSelectedNodeRelPaths' must not be empty";
        this.m_selectedNodeRelPaths.add(relPath);
    }

    public void addSelectedDependency(ArchitecturalViewNode from, ArchitecturalViewNode to, ArchitecturalViewDependencyDescriptor descriptor) {
        assert (from != null) : "Parameter 'from' of method 'addSelectedDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'addSelectedDependency' must not be null";
        assert (descriptor != null) : "Parameter 'descriptor' of method 'addSelectedDependency' must not be null";
        this.m_selectedDependencies.put((StrictPair<ArchitecturalViewNode, ArchitecturalViewNode>)new StrictPair((Object)from, (Object)to), descriptor);
    }

    public Map<ArchitecturalViewNode, String> getExpanded() {
        return Collections.unmodifiableMap(this.m_expandedNodes);
    }

    public Map<ArchitecturalViewNode, String> getSelected() {
        return Collections.unmodifiableMap(this.m_selectedNodes);
    }

    public Set<String> getSelectedNodeRelPaths() {
        return Collections.unmodifiableSet(this.m_selectedNodeRelPaths);
    }

    public Map<StrictPair<ArchitecturalViewNode, ArchitecturalViewNode>, ArchitecturalViewDependencyDescriptor> getSelectedDependencies() {
        return Collections.unmodifiableMap(this.m_selectedDependencies);
    }

    public boolean isEmpty() {
        return this.m_expandedNodes.isEmpty() && this.m_selectedNodes.isEmpty() && this.m_selectedDependencies.isEmpty() && this.m_selectedNodeRelPaths.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_expandedNodes.hashCode();
        result = 31 * result + this.m_selectedNodes.hashCode();
        result = 31 * result + this.m_selectedNodeRelPaths.hashCode();
        result = 31 * result + this.m_selectedDependencies.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArchitecturalViewState other = (ArchitecturalViewState)obj;
        return this.m_expandedNodes.equals(other.m_expandedNodes) && this.m_selectedNodes.equals(other.m_selectedNodes) && this.m_selectedDependencies.equals(other.m_selectedDependencies) && this.m_selectedNodeRelPaths.equals(other.m_selectedNodeRelPaths);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Empty";
        }
        StringBuilder builder = new StringBuilder();
        for (String string : this.m_expandedNodes.values()) {
            builder.append("Expanded node: ").append(string).append("\n");
        }
        for (String string : this.m_selectedNodes.values()) {
            builder.append("Selected node: ").append(string).append("\n");
        }
        for (String string : this.m_selectedNodeRelPaths) {
            builder.append("Selected node rel path: ").append(string).append("\n");
        }
        for (ArchitecturalViewDependencyDescriptor architecturalViewDependencyDescriptor : this.m_selectedDependencies.values()) {
            builder.append("Selected dependency: ").append(architecturalViewDependencyDescriptor).append("\n");
        }
        return builder.toString();
    }
}

