/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.collections.HashBag;
import com.hello2morrow.foundation.propertyreader.IntProperty;
import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.dependenciesview.DependenciesViewDependencyAdapter;
import com.hello2morrow.sonargraph.core.model.dependenciesview.DependenciesViewDependencyInfo;
import com.hello2morrow.sonargraph.core.model.dependenciesview.DeprecationInfo;
import com.hello2morrow.sonargraph.core.model.dependenciesview.ViolationInfo;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IDependency;
import com.hello2morrow.sonargraph.core.model.element.IDependencyAdapter;
import com.hello2morrow.sonargraph.core.model.element.IDependencyWithIssues;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.EmptyNodeProgrammingElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewDependencyFlags;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewNodeFlags;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.IExplorationViewDependencyInfoProvider;
import com.hello2morrow.sonargraph.core.model.programming.IParserDependenciesProvidingEdge;
import com.hello2morrow.sonargraph.core.model.programming.IParserDependenciesProvidingNode;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class ArchitecturalViewNode
extends ArchitecturalViewElement
implements IParserDependenciesProvidingNode,
Comparable<ArchitecturalViewNode> {
    private Map<ArchitecturalViewNode, ArchitecturalViewDependency> m_fromToIncomingDependencies;
    private Map<ArchitecturalViewNode, ArchitecturalViewDependency> m_toToOutgoingDependencies;
    private int m_level = 0;
    private int m_cycleIndex = -1;
    private int m_cycleLevel = -1;
    private int m_depth = 0;
    private int m_relativeIndex = -1;
    private int m_flags = 0;

    protected ArchitecturalViewNode(ArchitecturalViewElement parent, PresentationMode presentationMode, boolean isReadOnly) {
        super(parent);
        assert (parent != null) : "Parameter 'parent' of method 'ArchitecturalViewNode' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'ArchitecturalViewNode' must not be null";
        this.m_flags = ExplorationViewNodeFlags.setPresentationMode(presentationMode, this.m_flags);
        this.m_flags = ExplorationViewNodeFlags.setEnabled(isReadOnly, this.m_flags, 262144);
        this.setDepth(parent);
    }

    protected ArchitecturalViewNode(ArchitecturalViewElement parent, ArchitecturalViewNode copyOf) {
        super(parent);
        assert (parent != null) : "Parameter 'parent' of method 'ArchitecturalViewNode' must not be null";
        assert (copyOf != null) : "Parameter 'copyOf' of method 'ArchitecturalViewNode' must not be null";
        this.m_flags = copyOf.m_flags;
        this.setDepth(parent);
    }

    public EmptyNodeProgrammingElement getEmptyNodeProgrammingElement() {
        return null;
    }

    public boolean supportsAutoExpand() {
        return true;
    }

    public boolean supportsCopy() {
        return false;
    }

    public abstract ArchitecturalViewNode copy(ArchitecturalViewElement var1);

    public final void setRelativeIndex(int index) {
        this.m_relativeIndex = index;
    }

    @Override
    public int getRelativeIndex() {
        return this.m_relativeIndex;
    }

    public final void setLevel(int level) {
        this.m_level = level;
    }

    @Override
    public final int getLevel() {
        return this.m_level;
    }

    public final void setCycleIndex(int index) {
        this.m_cycleIndex = index;
    }

    @Override
    public final int getCycleIndex() {
        return this.m_cycleIndex;
    }

    @Override
    public final int getLevelInCycle() {
        return this.m_cycleLevel;
    }

    public final void setLevelInCycle(int level) {
        this.m_cycleLevel = level;
    }

    @Override
    public final boolean changeParent(NamedElement parent, boolean updateChildRelationship) {
        assert (false) : "Not supported: changeParent(final NamedElement parent, final boolean updateChildRelationship) - use: changeParentAndOrPos";
        return false;
    }

    @Override
    public final void setParent(NamedElement parent) {
        assert (false) : "Not supported: setParent(NamedElement parent) - use: changeParentAndOrPos";
    }

    @Override
    public final int compareTo(ArchitecturalViewNode other) {
        assert (other != null) : "Parameter 'other' of method 'compareTo' must not be null";
        return this.getRelativeIndex() - other.getRelativeIndex();
    }

    private void setDepth(ArchitecturalViewElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'setDepth' must not be null";
        if (this.isSuppressed() || this.isDeleted() || !(parent instanceof ArchitecturalViewNode)) {
            this.m_depth = 0;
        } else {
            ArchitecturalViewNode nonSuppressedParent = this.getNodeParent();
            assert (nonSuppressedParent != null) : "Parameter 'nonSuppressedParent' of method 'setDepth' must not be null";
            this.m_depth = nonSuppressedParent.getDepth() + 1;
        }
    }

    @Override
    public final void updateDepth() {
        this.setDepth((ArchitecturalViewElement)this.getParent());
    }

    private void setDepth(List<ArchitecturalViewNode> children, PresentationMode presentationMode, short depth) {
        assert (children != null) : "Parameter 'children' of method 'setDepth' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'setDepth' must not be null";
        for (ArchitecturalViewNode nextChild : children) {
            nextChild.m_depth = depth;
            this.setDepth(nextChild.getNodeChildren(n2 -> true, false), presentationMode, (short)(depth + 1));
        }
    }

    @Override
    public final int getDepth() {
        return this.m_depth;
    }

    @Override
    public final boolean isReadOnly() {
        return ExplorationViewNodeFlags.isEnabled(this.m_flags, 262144);
    }

    @Override
    public final boolean isDeleted() {
        return ExplorationViewNodeFlags.isEnabled(this.m_flags, 1024);
    }

    public final void setRefactored(boolean refactored) {
        this.m_flags = ExplorationViewNodeFlags.setEnabled(refactored, this.m_flags, 512);
    }

    public final void setDeleted(boolean deleted) {
        this.m_flags = ExplorationViewNodeFlags.setEnabled(deleted, this.m_flags, 1024);
    }

    public final void setPart(boolean part) {
        this.m_flags = ExplorationViewNodeFlags.setEnabled(part, this.m_flags, 65536);
    }

    public final void setSuppressed(boolean suppressed) {
        this.m_flags = ExplorationViewNodeFlags.setEnabled(suppressed, this.m_flags, 32768);
    }

    public final void setDeletedRecycled(boolean deletedRecycled) {
        this.m_flags = ExplorationViewNodeFlags.setEnabled(deletedRecycled, this.m_flags, 131072);
    }

    public final void setDeletedFlat(boolean deletedFlat) {
        this.m_flags = ExplorationViewNodeFlags.setEnabled(deletedFlat, this.m_flags, 2048);
    }

    @Override
    public boolean isDeletedFlat() {
        return ExplorationViewNodeFlags.isEnabled(this.m_flags, 2048);
    }

    @Override
    public final boolean isHidden() {
        return ExplorationViewNodeFlags.isEnabled(this.m_flags, 256);
    }

    public final void setHidden(boolean hidden) {
        this.m_flags = ExplorationViewNodeFlags.setEnabled(hidden, this.m_flags, 256);
    }

    @Override
    public final boolean isSuppressed() {
        return ExplorationViewNodeFlags.isEnabled(this.m_flags, 32768);
    }

    @Override
    public final boolean isDeletedRecycled() {
        return ExplorationViewNodeFlags.isEnabled(this.m_flags, 131072);
    }

    @Override
    public final boolean isPart() {
        return ExplorationViewNodeFlags.isEnabled(this.m_flags, 65536);
    }

    @Override
    public final boolean isRefactored() {
        return ExplorationViewNodeFlags.isEnabled(this.m_flags, 512);
    }

    @Override
    public final boolean isRemovedByFocus() {
        return ExplorationViewNodeFlags.isEnabled(this.m_flags, 4096);
    }

    public final void setRemovedByFocus(boolean removed) {
        this.m_flags = ExplorationViewNodeFlags.setEnabled(removed, this.m_flags, 4096);
    }

    @Override
    public final boolean hasPartialElements() {
        return ExplorationViewNodeFlags.isEnabled(this.m_flags, 8192);
    }

    public final void setHasPartialElements(boolean partial) {
        this.m_flags = ExplorationViewNodeFlags.setEnabled(partial, this.m_flags, 8192);
    }

    @Override
    public final boolean hasPartialDependencies() {
        return ExplorationViewNodeFlags.isEnabled(this.m_flags, 16384);
    }

    public final void setHasPartialDependencies(boolean partial) {
        this.m_flags = ExplorationViewNodeFlags.setEnabled(partial, this.m_flags, 16384);
    }

    @Override
    protected final void addedAsChildTo(ArchitecturalViewElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'addedAsChildTo' must not be null";
        this.setDepth(parent);
        super.addedAsChildTo(parent);
    }

    public final boolean changeParentAndOrPos(ArchitecturalViewElement parent, int atPos) {
        assert (parent != null) : "Parameter 'parent' of method 'changeParentAndOrPos' must not be null";
        ArchitecturalViewElement currentParent = this.getParent(ArchitecturalViewElement.class, ParentMode.ONLY_DIRECT_PARENT);
        assert (currentParent != null) : "'previousParent' of method 'changeParentAndOrPos' must not be null";
        boolean parentChanges = parent != currentParent;
        int currentPos = currentParent.getChildrenList().indexOf(this);
        assert (currentPos != -1) : "Not a child of parent: " + this.getElementInfo() + "/" + currentParent + this.getElementInfo();
        if (parentChanges || currentPos != atPos) {
            ArchitecturalViewNode relevantParentForDepthPropagation;
            int delta = !parentChanges && atPos != -1 && currentPos <= atPos ? -1 : 0;
            currentParent.removeChild(this);
            super.setParent(parent);
            parent.appendOrInsertChild(this, atPos + delta);
            ArchitecturalViewNode architecturalViewNode = relevantParentForDepthPropagation = this.isSuppressed() ? this.getNodeParent() : this;
            assert (relevantParentForDepthPropagation != null) : "'relevantParentForDepthPropagation' of method 'changeParent' must not be null";
            this.setDepth(this.getNodeChildren(n2 -> true, false), this.getPresentationMode(), (short)(((ArchitecturalViewElement)relevantParentForDepthPropagation).getDepth() + 1));
            return true;
        }
        return false;
    }

    @Override
    public final void setPresentationMode(PresentationMode presentationMode) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'setPresentationMode' must not be null";
        this.m_flags = ExplorationViewNodeFlags.setPresentationMode(presentationMode, this.m_flags);
    }

    @Override
    public final PresentationMode getPresentationMode() {
        return ExplorationViewNodeFlags.getPresentationMode(this.m_flags);
    }

    @Override
    public final boolean canBeVisible() {
        return !this.isSuppressed() && VISIBLE.test(this);
    }

    @Override
    public final boolean isVisible() {
        if (this.canBeVisible()) {
            ArchitecturalViewNode parent = this.getNodeParent();
            return parent == null ? true : parent.isExpanded();
        }
        return false;
    }

    public final void setIsExpandable(boolean isExpandable) {
        this.m_flags = ExplorationViewNodeFlags.setEnabled(isExpandable, this.m_flags, 8);
    }

    @Override
    public final boolean isExpandable() {
        return ExplorationViewNodeFlags.isEnabled(this.m_flags, 8);
    }

    @Override
    public final boolean isLazyExpandable() {
        return ExplorationViewNodeFlags.isEnabled(this.m_flags, 524288);
    }

    public final void setIsLazyExpandable(boolean isExpandable) {
        this.m_flags = ExplorationViewNodeFlags.setEnabled(isExpandable, this.m_flags, 524288);
    }

    public final void setExpanded(boolean expanded) {
        this.m_flags = ExplorationViewNodeFlags.setEnabled(expanded, this.m_flags, 16);
    }

    @Override
    public final boolean isExpanded() {
        return ExplorationViewNodeFlags.isEnabled(this.m_flags, 16);
    }

    @Override
    public final void setSelected(boolean selected) {
        this.m_flags = ExplorationViewNodeFlags.setEnabled(selected, this.m_flags, 32);
    }

    @Override
    public final boolean isSelected() {
        return ExplorationViewNodeFlags.isEnabled(this.m_flags, 32);
    }

    @Override
    public final boolean isParentSelected() {
        ArchitecturalViewNode currentParent = this.getNodeParent();
        while (currentParent != null) {
            if (currentParent.isSelected()) {
                return true;
            }
            currentParent = currentParent.getNodeParent();
        }
        return false;
    }

    public final void setHasViolation(boolean has) {
        this.m_flags = ExplorationViewNodeFlags.setEnabled(has, this.m_flags, 64);
    }

    @Override
    @Property
    public final boolean hasViolation() {
        return ExplorationViewNodeFlags.isEnabled(this.m_flags, 64);
    }

    public final void setHasDeprecation(boolean has) {
        this.m_flags = ExplorationViewNodeFlags.setEnabled(has, this.m_flags, 128);
    }

    @Override
    @Property
    public final boolean hasDeprecation() {
        return ExplorationViewNodeFlags.isEnabled(this.m_flags, 128);
    }

    @Override
    public final ArchitecturalViewNode getNamedElement() {
        return this;
    }

    public final boolean hasDependencies() {
        return this.m_fromToIncomingDependencies != null && !this.m_fromToIncomingDependencies.isEmpty() || this.m_toToOutgoingDependencies != null && !this.m_toToOutgoingDependencies.isEmpty();
    }

    public final synchronized Collection<ArchitecturalViewDependency> getIncomingDependencies() {
        return this.m_fromToIncomingDependencies == null ? Collections.emptyList() : new ArrayList<ArchitecturalViewDependency>(this.m_fromToIncomingDependencies.values());
    }

    public final Iterator<ArchitecturalViewDependency> getIncomingDependenciesIterator() {
        return this.m_fromToIncomingDependencies == null ? Collections.emptyIterator() : this.m_fromToIncomingDependencies.values().iterator();
    }

    public final synchronized Collection<ArchitecturalViewDependency> getOutgoingDependencies() {
        return this.m_toToOutgoingDependencies == null ? Collections.emptyList() : new ArrayList<ArchitecturalViewDependency>(this.m_toToOutgoingDependencies.values());
    }

    public final Iterator<ArchitecturalViewDependency> getOutgoingDependenciesIterator() {
        return this.m_toToOutgoingDependencies == null ? Collections.emptyIterator() : this.m_toToOutgoingDependencies.values().iterator();
    }

    public final ArchitecturalViewDependency getOutgoingDependency(ArchitecturalViewNode to) {
        assert (to != null) : "Parameter 'to' of method 'getOutgoingDependency' must not be null";
        return this.m_toToOutgoingDependencies == null ? null : this.m_toToOutgoingDependencies.get(to);
    }

    @Override
    public final List<ParserDependency> getIncomingParserDependencies() {
        if (this.m_fromToIncomingDependencies == null) {
            return Collections.emptyList();
        }
        ArrayList<ParserDependency> parserDependencies = new ArrayList<ParserDependency>();
        this.m_fromToIncomingDependencies.values().forEach(d2 -> {
            boolean bl2 = parserDependencies.addAll(d2.getParserDependencies());
        });
        return parserDependencies;
    }

    @Override
    public final List<ParserDependency> getOutgoingParserDependencies() {
        if (this.m_toToOutgoingDependencies == null) {
            return Collections.emptyList();
        }
        ArrayList<ParserDependency> parserDependencies = new ArrayList<ParserDependency>();
        this.m_toToOutgoingDependencies.values().forEach(d2 -> {
            boolean bl2 = parserDependencies.addAll(d2.getParserDependencies());
        });
        return parserDependencies;
    }

    public final void finishDependenciesModification(IExplorationViewDependencyInfoProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'finishDependenciesModification' must not be null";
        if (this.m_fromToIncomingDependencies != null && this.m_fromToIncomingDependencies.isEmpty()) {
            this.m_fromToIncomingDependencies = null;
        }
        if (this.m_toToOutgoingDependencies != null && this.m_toToOutgoingDependencies.isEmpty()) {
            this.m_toToOutgoingDependencies = null;
        }
        if (this.m_fromToIncomingDependencies != null) {
            this.m_fromToIncomingDependencies.values().forEach(i2 -> i2.update(provider));
        }
        if (this.m_toToOutgoingDependencies != null) {
            this.m_toToOutgoingDependencies.values().forEach(o2 -> o2.update(provider));
        }
    }

    private void addDependencyFrom(ArchitecturalViewDependency fromDependency) {
        assert (fromDependency != null) : "Parameter 'fromDependency' of method 'addDependencyFrom' must not be null";
        if (this.m_fromToIncomingDependencies == null) {
            this.m_fromToIncomingDependencies = Collections.synchronizedMap(new THashMap());
        }
        this.m_fromToIncomingDependencies.put(fromDependency.getFrom(), fromDependency);
    }

    private void addDependencyTo(ArchitecturalViewDependency toDependency) {
        assert (toDependency != null) : "Parameter 'toDependency' of method 'addDependencyTo' must not be null";
        if (this.m_toToOutgoingDependencies == null) {
            this.m_toToOutgoingDependencies = Collections.synchronizedMap(new THashMap());
        }
        this.m_toToOutgoingDependencies.put(toDependency.getTo(), toDependency);
    }

    public void addDependendencyFrom(ArchitecturalViewNode from, ParserDependency parserDependency, IExplorationViewDependencyInfoProvider provider) {
        ArchitecturalViewDependency dependency;
        assert (from != null) : "Parameter 'to' of method 'addDependendencyFrom' must not be null";
        assert (parserDependency != null) : "Parameter 'parserDependency' of method 'addDependendencyFrom' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'addDependendencyFrom' must not be null";
        if (this.m_fromToIncomingDependencies == null) {
            this.m_fromToIncomingDependencies = Collections.synchronizedMap(new THashMap());
        }
        if ((dependency = this.m_fromToIncomingDependencies.get(from)) == null) {
            dependency = new ArchitecturalViewDependency(from, this);
            this.m_fromToIncomingDependencies.put(from, dependency);
            from.addDependencyTo(dependency);
        }
        dependency.addParserDependency(parserDependency, provider.isViolation(parserDependency), provider.isDeprecation(parserDependency), provider.getIssues(parserDependency), true);
    }

    public void addDependendencyTo(ArchitecturalViewNode to, ParserDependency parserDependency, IExplorationViewDependencyInfoProvider provider, boolean inExpandOrCollapse) {
        ArchitecturalViewDependency dependency;
        assert (to != null) : "Parameter 'to' of method 'addDependendencyTo' must not be null";
        assert (parserDependency != null) : "Parameter 'parserDependency' of method 'addDependendencyTo' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'addDependendencyTo' must not be null";
        if (this.m_toToOutgoingDependencies == null) {
            this.m_toToOutgoingDependencies = Collections.synchronizedMap(new THashMap());
        }
        if ((dependency = this.m_toToOutgoingDependencies.get(to)) == null) {
            dependency = new ArchitecturalViewDependency(this, to);
            this.m_toToOutgoingDependencies.put(to, dependency);
            to.addDependencyFrom(dependency);
        }
        dependency.addParserDependency(parserDependency, provider.isViolation(parserDependency), provider.isDeprecation(parserDependency), provider.getIssues(parserDependency), inExpandOrCollapse);
    }

    public void removeDependencyFrom(ArchitecturalViewDependency fromDependency) {
        assert (fromDependency != null) : "Parameter 'fromDependency' of method 'addDependencyFrom' must not be null";
        assert (this.m_fromToIncomingDependencies != null) : "'m_fromToIncomingDependencies' of method 'removeDependencyFrom' must not be null";
        ArchitecturalViewDependency previous = this.m_fromToIncomingDependencies.remove(fromDependency.getFrom());
        assert (previous != null) : "'previous' of method 'removeDependencyFrom' must not be null";
        if (this.m_fromToIncomingDependencies.isEmpty()) {
            this.m_fromToIncomingDependencies = null;
        }
    }

    public void removeDependencyTo(ArchitecturalViewDependency toDependency) {
        assert (toDependency != null) : "Parameter 'toDependency' of method 'addDependencyTo' must not be null";
        assert (this.m_toToOutgoingDependencies != null) : "'m_toToOutgoingoDependencies' of method 'removeDependencyTo' must not be null";
        ArchitecturalViewDependency previous = this.m_toToOutgoingDependencies.remove(toDependency.getTo());
        assert (previous != null) : "'previous' of method 'removeDependencyTo' must not be null";
        if (this.m_toToOutgoingDependencies.isEmpty()) {
            this.m_toToOutgoingDependencies = null;
        }
    }

    public final ArchitecturalViewNode getNodeParent() {
        ArchitecturalViewNode currentParent = this.getParent(ArchitecturalViewNode.class, new Class[0]);
        if (currentParent == null) {
            assert (!this.isSuppressed()) : "suppressed node has no direct parent in '" + (Object)((Object)this.getPresentationMode()) + "' mode: " + this.getElementInfo();
            return null;
        }
        switch (this.getPresentationMode()) {
            case HIERARCHICAL: 
            case MIXED: {
                if (!currentParent.isSuppressed()) break;
                while ((currentParent = currentParent.getParent(ArchitecturalViewNode.class, new Class[0])) != null && currentParent.isSuppressed()) {
                }
                break;
            }
            case FLAT: {
                assert (currentParent != null) : "'currentParent' of method 'getParent' must not be null in '" + (Object)((Object)this.getPresentationMode()) + "' mode for: " + this.getElementInfo();
                if (this.isRecursive()) {
                    while (currentParent != null && currentParent.isRecursive()) {
                        currentParent = currentParent.getParent(ArchitecturalViewNode.class, new Class[0]);
                    }
                    break;
                }
                if (!currentParent.isSuppressed()) break;
                while ((currentParent = currentParent.getParent(ArchitecturalViewNode.class, new Class[0])) != null && currentParent.isSuppressed()) {
                }
                break;
            }
            case NONE: {
                if (!currentParent.isRecursive()) break;
                while ((currentParent = currentParent.getParent(ArchitecturalViewNode.class, new Class[0])) != null && currentParent.isRecursive()) {
                }
                break;
            }
            default: {
                assert (false) : "Unhandled presentation mode: " + (Object)((Object)this.getPresentationMode());
                break;
            }
        }
        assert (currentParent != null) : "Parent not found in '" + (Object)((Object)this.getPresentationMode()) + "' mode for: " + this.getElementInfo();
        return currentParent;
    }

    private void collectNonRecursiveChildren(ArrayList<NamedElement> childrenList, Predicate<ArchitecturalViewElement> include, List<ArchitecturalViewNode> collector) {
        assert (include != null) : "Parameter 'include' of method 'collectNonSuppressedRecursiveChildren' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'collectNonSuppressedRecursiveChildren' must not be null";
        if (childrenList != null && !childrenList.isEmpty()) {
            for (NamedElement nextChild : childrenList) {
                if (!(nextChild instanceof ArchitecturalViewNode)) continue;
                ArchitecturalViewNode nextChildNode = (ArchitecturalViewNode)nextChild;
                if (nextChildNode.isRecursive()) {
                    this.collectNonRecursiveChildren(nextChildNode.getModifiableChildrenList(), include, collector);
                    continue;
                }
                if (!include.test(nextChildNode)) continue;
                collector.add(nextChildNode);
            }
        }
    }

    private boolean hasNonRecursiveChild(ArrayList<NamedElement> childrenList, Predicate<ArchitecturalViewElement> include) {
        if (childrenList != null && !childrenList.isEmpty()) {
            for (NamedElement nextChild : childrenList) {
                ArchitecturalViewNode nextChildNode;
                if (!(nextChild instanceof ArchitecturalViewNode) || !((nextChildNode = (ArchitecturalViewNode)nextChild).isRecursive() ? this.hasNonRecursiveChild(nextChildNode.getModifiableChildrenList(), include) : include.test(nextChildNode))) continue;
                return true;
            }
        }
        return false;
    }

    private void collectNonSuppressedRecursiveChildren(ArrayList<NamedElement> childrenList, Predicate<ArchitecturalViewElement> include, List<ArchitecturalViewNode> collector, boolean firstNonSuppressedOnly) {
        assert (include != null) : "Parameter 'include' of method 'collectNonSuppressedRecursiveChildren' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'collectNonSuppressedRecursiveChildren' must not be null";
        if (childrenList != null && !childrenList.isEmpty()) {
            for (NamedElement nextChild : childrenList) {
                ArchitecturalViewNode nextChildNode;
                if (!(nextChild instanceof ArchitecturalViewNode) || !(nextChildNode = (ArchitecturalViewNode)nextChild).isRecursive()) continue;
                if (!nextChildNode.isSuppressed()) {
                    if (include.test(nextChildNode)) {
                        collector.add(nextChildNode);
                    }
                    if (firstNonSuppressedOnly) continue;
                    this.collectNonSuppressedRecursiveChildren(nextChildNode.getModifiableChildrenList(), include, collector, firstNonSuppressedOnly);
                    continue;
                }
                this.collectNonSuppressedRecursiveChildren(nextChildNode.getModifiableChildrenList(), include, collector, firstNonSuppressedOnly);
            }
        }
    }

    private boolean hasNonSuppressedRecursiveChild(ArrayList<NamedElement> childrenList, Predicate<ArchitecturalViewElement> include, boolean firstNonSuppressedOnly) {
        if (childrenList != null && !childrenList.isEmpty()) {
            for (NamedElement nextChild : childrenList) {
                ArchitecturalViewNode nextChildNode;
                if (!(nextChild instanceof ArchitecturalViewNode) || !(nextChildNode = (ArchitecturalViewNode)nextChild).isRecursive()) continue;
                if (!nextChildNode.isSuppressed()) {
                    if (include.test(nextChildNode)) {
                        return true;
                    }
                    if (firstNonSuppressedOnly || !this.hasNonSuppressedRecursiveChild(nextChildNode.getModifiableChildrenList(), include, firstNonSuppressedOnly)) continue;
                    return true;
                }
                if (!this.hasNonSuppressedRecursiveChild(nextChildNode.getModifiableChildrenList(), include, firstNonSuppressedOnly)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean hasNodeChildren(Predicate<ArchitecturalViewElement> include) {
        block11: {
            assert (include != null) : "Parameter 'include' of method 'hasNodeChildren' must not be null";
            ArrayList<NamedElement> childrenList = this.getModifiableChildrenList();
            if (childrenList == null || childrenList.isEmpty()) break block11;
            PresentationMode presentationMode = this.getPresentationMode();
            if (presentationMode == PresentationMode.HIERARCHICAL) {
                for (NamedElement nextChild : childrenList) {
                    if (!(nextChild instanceof ArchitecturalViewNode) || ((ArchitecturalViewNode)nextChild).isSuppressed() || !include.test((ArchitecturalViewNode)nextChild)) continue;
                    return true;
                }
            } else if (presentationMode == PresentationMode.NONE) {
                for (NamedElement nextChild : childrenList) {
                    ArchitecturalViewNode nextChildNode;
                    if (!(nextChild instanceof ArchitecturalViewNode) || !((nextChildNode = (ArchitecturalViewNode)nextChild).isRecursive() ? this.hasNonRecursiveChild(nextChildNode.getModifiableChildrenList(), include) : include.test(nextChildNode))) continue;
                    return true;
                }
            } else {
                assert (presentationMode.equals((Object)PresentationMode.MIXED) || presentationMode.equals((Object)PresentationMode.FLAT)) : "Unexpected presentation mode: " + (Object)((Object)presentationMode);
                boolean firstNonSuppressedOnly = presentationMode.equals((Object)PresentationMode.MIXED);
                boolean skipRecursiveChildren = presentationMode.equals((Object)PresentationMode.FLAT) && this.isRecursive() && !this.isSuppressed();
                for (NamedElement nextChild : childrenList) {
                    if (!(nextChild instanceof ArchitecturalViewNode)) continue;
                    ArchitecturalViewNode nextChildNode = (ArchitecturalViewNode)nextChild;
                    if (skipRecursiveChildren && nextChildNode.isRecursive()) continue;
                    if (!nextChildNode.isSuppressed()) {
                        if (include.test(nextChildNode)) {
                            return true;
                        }
                        if (firstNonSuppressedOnly) continue;
                    }
                    if (!nextChildNode.isRecursive() || !this.hasNonSuppressedRecursiveChild(nextChildNode.getModifiableChildrenList(), include, firstNonSuppressedOnly)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public final List<ArchitecturalViewNode> getNodeChildren(Predicate<ArchitecturalViewElement> include, boolean sorted) {
        assert (include != null) : "Parameter 'include' of method 'getNodeChildren' must not be null";
        ArrayList<NamedElement> childrenList = this.getModifiableChildrenList();
        if (childrenList == null || childrenList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ArchitecturalViewNode> childNodes = new ArrayList<ArchitecturalViewNode>();
        PresentationMode presentationMode = this.getPresentationMode();
        if (presentationMode == PresentationMode.HIERARCHICAL) {
            for (NamedElement nextChild : childrenList) {
                if (!(nextChild instanceof ArchitecturalViewNode) || ((ArchitecturalViewNode)nextChild).isSuppressed() || !include.test((ArchitecturalViewNode)nextChild)) continue;
                childNodes.add((ArchitecturalViewNode)nextChild);
            }
        } else if (presentationMode == PresentationMode.NONE) {
            for (NamedElement nextChild : childrenList) {
                if (!(nextChild instanceof ArchitecturalViewNode)) continue;
                ArchitecturalViewNode nextChildNode = (ArchitecturalViewNode)nextChild;
                if (nextChildNode.isRecursive()) {
                    this.collectNonRecursiveChildren(nextChildNode.getModifiableChildrenList(), include, childNodes);
                    continue;
                }
                if (!include.test(nextChildNode)) continue;
                childNodes.add(nextChildNode);
            }
        } else {
            assert (presentationMode.equals((Object)PresentationMode.MIXED) || presentationMode.equals((Object)PresentationMode.FLAT)) : "Unexpected presentation mode: " + (Object)((Object)presentationMode);
            boolean firstNonSuppressedOnly = presentationMode.equals((Object)PresentationMode.MIXED);
            boolean skipRecursiveChildren = presentationMode.equals((Object)PresentationMode.FLAT) && this.isRecursive() && !this.isSuppressed();
            for (NamedElement nextChild : childrenList) {
                if (!(nextChild instanceof ArchitecturalViewNode)) continue;
                ArchitecturalViewNode nextChildNode = (ArchitecturalViewNode)nextChild;
                if (skipRecursiveChildren && nextChildNode.isRecursive()) continue;
                if (!nextChildNode.isSuppressed()) {
                    if (include.test(nextChildNode)) {
                        childNodes.add(nextChildNode);
                    }
                    if (firstNonSuppressedOnly) continue;
                }
                if (!nextChildNode.isRecursive()) continue;
                this.collectNonSuppressedRecursiveChildren(nextChildNode.getModifiableChildrenList(), include, childNodes, firstNonSuppressedOnly);
            }
        }
        childNodes.trimToSize();
        return Collections.unmodifiableList(sorted ? childNodes.parallelStream().sorted().collect(Collectors.toList()) : childNodes);
    }

    public final boolean hasAllNodeChildren(Predicate<ArchitecturalViewElement> include) {
        assert (include != null) : "Parameter 'include' of method 'getAllNodeChildren' must not be null";
        ArrayList<NamedElement> childrenList = this.getModifiableChildrenList();
        if (childrenList == null || childrenList.isEmpty()) {
            return false;
        }
        for (NamedElement nextChild : childrenList) {
            if (!(nextChild instanceof ArchitecturalViewNode) || !include.test((ArchitecturalViewNode)nextChild)) continue;
            return true;
        }
        return false;
    }

    public final List<ArchitecturalViewNode> getAllNodeChildren(Predicate<ArchitecturalViewElement> include, boolean sorted) {
        assert (include != null) : "Parameter 'include' of method 'getAllNodeChildren' must not be null";
        ArrayList<NamedElement> childrenList = this.getModifiableChildrenList();
        if (childrenList == null || childrenList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ArchitecturalViewNode> childNodes = new ArrayList<ArchitecturalViewNode>();
        for (NamedElement nextChild : childrenList) {
            if (!(nextChild instanceof ArchitecturalViewNode) || !include.test((ArchitecturalViewNode)nextChild)) continue;
            childNodes.add((ArchitecturalViewNode)nextChild);
        }
        childNodes.trimToSize();
        return Collections.unmodifiableList(sorted ? childNodes.parallelStream().sorted().collect(Collectors.toList()) : childNodes);
    }

    public final List<ArchitecturalViewNode> getVisibleNodeChildren() {
        return this.isExpanded() ? this.getNodeChildren(VISIBLE, false) : Collections.emptyList();
    }

    public final List<ArchitecturalViewNode> getSortedVisibleNodeChildren() {
        return this.isExpanded() ? this.getNodeChildren(VISIBLE, true) : Collections.emptyList();
    }

    private int getNumberOfVisibleChildren(PresentationMode presentationMode, ArchitecturalViewNode node, int number) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'getNumberOfVisibleChildren' must not be null";
        assert (node != null) : "Parameter 'element' of method 'getNumberOfVisibleChildren' must not be null";
        if (node.isExpanded()) {
            for (ArchitecturalViewNode nextChild : node.getVisibleNodeChildren()) {
                ++number;
                number = this.getNumberOfVisibleChildren(presentationMode, nextChild, number);
            }
        }
        return number;
    }

    public final int getNumberOfVisibleChildrenRecursively() {
        return this.getNumberOfVisibleChildren(this.getPresentationMode(), this, 0);
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitArchitecturalViewNode(this);
        } else {
            super.accept(visitor);
        }
    }

    public static final class ArchitecturalViewDependency
    extends Element
    implements IDependencyAdapter,
    IDependencyWithIssues,
    IArchitecturalViewElement,
    IParserDependenciesProvidingEdge {
        private final ArchitecturalViewNode m_from;
        private final ArchitecturalViewNode m_to;
        private Collection<ParserDependency> m_dependencies = new HashBag(20);
        private DependenciesViewDependencyInfo m_info;
        private byte m_flags;

        ArchitecturalViewDependency(ArchitecturalViewNode from, ArchitecturalViewNode to) {
            assert (from != null) : "Parameter 'from' of method 'ArchitecturalViewDependency' must not be null";
            assert (to != null) : "Parameter 'to' of method 'ArchitecturalViewDependency' must not be null";
            this.m_from = from;
            this.m_to = to;
        }

        @Override
        public String getName() {
            return String.valueOf(this.getFrom().getName()) + " -> " + this.getTo().getName();
        }

        @Override
        public String getPresentationKind() {
            return this.m_from.isReadOnly() ? "Exploration View Dependency" : "Architectural View Dependency";
        }

        public ArchitecturalViewNode getFrom() {
            return this.m_from;
        }

        public ArchitecturalViewNode getTo() {
            return this.m_to;
        }

        @Override
        public ArchitecturalViewNode getFromEndPoint() {
            return this.m_from;
        }

        @Override
        public ArchitecturalViewNode getToEndPoint() {
            return this.m_to;
        }

        @Override
        public boolean isExternal() {
            return this.m_from.isExternal();
        }

        @Override
        public String getShortName() {
            return String.valueOf(this.m_from.getShortName()) + " -> " + this.m_to.getShortName();
        }

        @Override
        public Element.IPropertiesManager getPropertiesManager() {
            return this.m_from.getPropertiesManager();
        }

        @Override
        public synchronized boolean isValid() {
            return this.m_dependencies != null && this.m_from.isValid() && this.m_to.isValid();
        }

        public boolean isSelected() {
            return ExplorationViewDependencyFlags.isEnabled(this.m_flags, (byte)1);
        }

        public void setSelected(boolean selected) {
            this.m_flags = ExplorationViewDependencyFlags.setEnabled(selected, this.m_flags, (byte)1);
        }

        @Override
        @IntProperty
        public synchronized int getNumberOfParserDependencies() {
            return this.isValid() ? this.m_dependencies.size() : 0;
        }

        @IntProperty(undefinedValue=0)
        public synchronized int getNumberOfParserDependenciesViolating() {
            return this.m_info == null ? 0 : this.m_info.getNumberOfParserDependenciesViolating();
        }

        @IntProperty(undefinedValue=0)
        public synchronized int getNumberOfParserDependenciesViolatingToBeFixed() {
            return this.m_info == null ? 0 : this.m_info.getNumberOfParserDependenciesViolatingToBeFixed();
        }

        @IntProperty(undefinedValue=0)
        public synchronized int getNumberOfParserDependenciesViolatingIgnored() {
            return this.m_info == null ? 0 : this.m_info.getNumberOfParserDependenciesViolatingIgnored();
        }

        @Property
        public synchronized String getViolationInfo() {
            return this.m_info == null ? null : this.m_info.getViolationInfo();
        }

        @Property
        public synchronized String getViolationInfoToBeFixed() {
            return this.m_info == null ? null : this.m_info.getViolationInfoToBeFixed();
        }

        @Property
        public synchronized String getViolationInfoIgnored() {
            return this.m_info == null ? null : this.m_info.getViolationInfoIgnored();
        }

        @IntProperty(undefinedValue=0)
        public synchronized int getNumberOfParserDependenciesDeprecated() {
            return this.m_info == null ? 0 : this.m_info.getNumberOfParserDependenciesDeprecated();
        }

        @IntProperty(undefinedValue=0)
        public synchronized int getNumberOfParserDependenciesDeprecatedIgnored() {
            return this.m_info == null ? 0 : this.m_info.getNumberOfParserDependenciesDeprecatedIgnored();
        }

        @IntProperty(undefinedValue=0)
        public synchronized int getNumberOfParserDependenciesDeprecatedToBeFixed() {
            return this.m_info == null ? 0 : this.m_info.getNumberOfParserDependenciesDeprecatedToBeFixed();
        }

        @Property
        public synchronized String getDeprecationInfo() {
            return this.m_info == null ? null : this.m_info.getDeprecationInfo();
        }

        @Property
        public synchronized String getDeprecationInfoIgnored() {
            return this.m_info == null ? null : this.m_info.getDeprecationInfoIgnored();
        }

        @Property
        public synchronized String getDeprecationInfoToBeFixed() {
            return this.m_info == null ? null : this.m_info.getDeprecationInfoToBeFixed();
        }

        @Override
        public Collection<Issue> getRelevantIssues() {
            return this.m_info == null ? Collections.emptyList() : this.m_info.getIssues();
        }

        @Override
        public synchronized String getImageResourceName() {
            if (this.isValid()) {
                int number = this.getNumberOfParserDependenciesViolating();
                return number == 0 ? "NonViolatingDependency" : (number == this.m_dependencies.size() ? "FullViolatingDependency" : "PartiallyViolatingDependency");
            }
            return "InvalidDependency";
        }

        private void process(ViolationInfo violationInfo, DeprecationInfo deprecationInfo, Collection<Issue> issues) {
            if (violationInfo != null || deprecationInfo != null || issues != null) {
                if (this.m_info == null) {
                    this.m_info = new DependenciesViewDependencyInfo();
                }
                this.m_info.processInfo(violationInfo, deprecationInfo, issues);
            }
        }

        public void update(IExplorationViewDependencyInfoProvider provider) {
            assert (provider != null) : "Parameter 'provider' of method 'update' must not be null";
            assert (this.isValid()) : "Not valid: " + this;
            this.m_info = null;
            this.m_dependencies.forEach(d2 -> this.process(provider.isViolation((ParserDependency)d2), provider.isDeprecation((ParserDependency)d2), provider.getIssues((ParserDependency)d2)));
        }

        public synchronized void removed() {
            assert (this.isValid()) : "Not valid: " + this;
            this.m_dependencies.clear();
            this.m_dependencies = null;
        }

        public Iterator<ParserDependency> getParserDependenciesIterator() {
            assert (this.isValid()) : "Not valid: " + this;
            return this.m_dependencies.iterator();
        }

        private synchronized void addParserDependency(ParserDependency dependency, ViolationInfo violationInfo, DeprecationInfo deprecationInfo, Collection<Issue> issues, boolean inExpandOrCollapse) {
            assert (dependency != null) : "Parameter 'addParserDependency' of method 'add' must not be null";
            assert (this.isValid()) : "Not valid";
            if (!inExpandOrCollapse || !this.m_dependencies.contains(dependency)) {
                this.m_dependencies.add(dependency);
                this.process(violationInfo, deprecationInfo, issues);
            }
        }

        @Override
        public synchronized Collection<ParserDependency> getParserDependencies() {
            return this.isValid() ? new ArrayList<ParserDependency>(this.m_dependencies) : Collections.emptyList();
        }

        @Override
        public ParserDependency getFirstParserDependency() {
            return this.isValid() && !this.m_dependencies.isEmpty() ? this.m_dependencies.iterator().next() : null;
        }

        @Property
        public synchronized String getParserDependency() {
            return this.isValid() && this.m_dependencies.size() == 1 ? this.m_dependencies.iterator().next().getPresentationName(false) : null;
        }

        @Override
        public synchronized List<IDependency> getAdaptedTo() {
            if (this.isValid() && this.m_from.isReadOnly()) {
                return Collections.singletonList(new DependenciesViewDependencyAdapter(this.m_from.getFirstUnderlyingElement(), this.m_to.getFirstUnderlyingElement(), new ArrayList<ParserDependency>(this.m_dependencies)));
            }
            return Collections.emptyList();
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitArchitecturalViewNode(ArchitecturalViewNode var1);
    }
}

