/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ISourceElementProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.FilePath;

public abstract class ArchitecturalViewInfo<T extends Element>
extends NamedElement
implements ISourceElementProvider {
    private final ITopic m_topic;
    private final FilePath m_filePath;
    private final T m_sourceElement;
    private final String m_information;

    protected ArchitecturalViewInfo(NamedElement parent, ITopic topic, FilePath filePath, T sourceElement, String information) {
        super(parent);
        assert (parent != null) : "Parameter 'parent' of method 'ArchitecturalViewInfo' must not be null";
        assert (topic != null) : "Parameter 'topic' of method 'ArchitecturalViewInfo' must not be null";
        assert (filePath != null) : "Parameter 'filePath' of method 'ArchitecturalViewInfo' must not be null";
        assert (sourceElement != null) : "Parameter 'sourceElement' of method 'ArchitecturalViewInfo' must not be null";
        assert (information != null) : "Parameter 'information' of method 'ArchitecturalViewInfo' must not be null";
        this.m_topic = topic;
        this.m_filePath = filePath;
        this.m_sourceElement = sourceElement;
        this.m_information = information;
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return String.valueOf(super.getFullyQualifiedNamePart()) + Element.INNER_NAME_PARTS_SEPARATOR + this.m_sourceElement.hashCode();
    }

    @Override
    public final boolean isValid() {
        return ((Element)this.m_sourceElement).isValid();
    }

    @Override
    public final String getShortName() {
        return this.m_topic.getPresentationName();
    }

    @Override
    public final Element.IPropertiesManager getPropertiesManager() {
        return ((Element)this.m_sourceElement).getPropertiesManager();
    }

    public final ITopic getTopic() {
        return this.m_topic;
    }

    @Override
    public String getImageResourceName() {
        return this.m_topic.getImageResourceName();
    }

    public final String getIdentifyingFilePath() {
        return this.m_filePath.getIdentifyingPath();
    }

    public final String getIdentifyingFilePathImage() {
        return this.m_filePath.getImageResourceName();
    }

    public final T getSourceElement() {
        return this.m_sourceElement;
    }

    @Override
    public final int getLineNumber() {
        return ((Element)this.m_sourceElement).getLineNumber();
    }

    @Override
    public final String getInformation() {
        return this.m_information;
    }

    public abstract String getElementName();

    public abstract String getElementImage();

    public abstract String getToElementName();

    public abstract String getToElementImage();

    public static interface ITopic
    extends IStandardEnumeration {
        public String getImageResourceName();
    }
}

