/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.propertyreader.IntProperty;
import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.dependenciesview.DependenciesViewElement;
import com.hello2morrow.sonargraph.core.model.element.INamedElementAdapter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ArchitecturalViewElement
extends DependenciesViewElement
implements INamedElementAdapter,
IArchitecturalViewElement {
    public static final int NOT_LEVELIZED = 0;
    public static final int NOT_CYCLIC = -1;
    public static final int NO_LEVEL_IN_CYCLE = -1;
    public static final int NO_RELATIVE_INDEX = -1;
    public static final int RELATIVE_INDEX_APPEND = -1;
    public static final int DEFAULT_DEPTH = 0;
    public static final Predicate<ArchitecturalViewElement> VISIBLE = e2 -> !e2.isDeleted() && !e2.isDeletedFlat() && !e2.isRemovedByFocus();
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitecturalViewElement.class);

    protected ArchitecturalViewElement(NamedElement parent) {
        super(parent);
    }

    public boolean isAssignable() {
        return false;
    }

    public boolean isLazyExpandable() {
        return false;
    }

    @Override
    public final boolean isExcluded() {
        return false;
    }

    @Override
    public final boolean ignoreIssues() {
        return false;
    }

    public int getRelativeIndexOffset() {
        return 0;
    }

    public final int getNumberOfChildren(Class<? extends ArchitecturalViewElement> clazz) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getNumberOfChildren' must not be null";
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        if (children == null || children.isEmpty()) {
            return 0;
        }
        int number = 0;
        for (NamedElement next : children) {
            if (!clazz.isAssignableFrom(next.getClass())) continue;
            ++number;
        }
        return number;
    }

    public abstract int getRelativeIndex();

    public final ArchitecturalViewElement resolveByRelativePathPart(String namePart, boolean all) {
        assert (namePart != null && namePart.length() > 0) : "Parameter 'namePart' of method 'resolveByRelativePathPart' must not be empty";
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        if (children != null) {
            for (NamedElement nextChild : children) {
                if (!(nextChild instanceof ArchitecturalViewElement) || !namePart.equals(nextChild.getFullyQualifiedNamePart())) continue;
                if (all || VISIBLE.test((ArchitecturalViewElement)nextChild)) {
                    return (ArchitecturalViewElement)nextChild;
                }
                return null;
            }
        }
        return null;
    }

    public final ArchitecturalViewElement resolveByShortName(String shortName) {
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'resolveByShortName' must not be empty";
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        if (children != null) {
            for (NamedElement nextChild : children) {
                if (!(nextChild instanceof ArchitecturalViewElement) || !shortName.equals(((ArchitecturalViewElement)nextChild).getRawPresentationName(true))) continue;
                return (ArchitecturalViewElement)nextChild;
            }
        }
        return null;
    }

    protected void addedAsChildTo(ArchitecturalViewElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'addedAsChildTo' must not be null";
    }

    public final void appendOrInsertChild(ArchitecturalViewElement child, int atPos) {
        assert (child != null) : "Parameter 'child' of method 'appendOrInsertChild' must not be null";
        assert (atPos >= -1) : "Invalid 'atPos':" + atPos;
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        if (children == null) {
            children = new ArrayList();
            this.setModifiableChildrenList(children);
        }
        if (atPos == -1) {
            children.add(child);
        } else {
            children.add(atPos, child);
        }
        child.addedAsChildTo(this);
    }

    public final void addChild(ArchitecturalViewElement child, Class<? extends ArchitecturalViewElement> clazz) {
        assert (child != null) : "Parameter 'child' of method 'addChild' must not be null";
        assert (clazz != null) : "Parameter 'clazz' of method 'addChild' must not be null";
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        if (children == null) {
            children = new ArrayList();
            this.setModifiableChildrenList(children);
        }
        if (children.isEmpty() || clazz.isAssignableFrom(children.get(children.size() - 1).getClass())) {
            children.add(child);
        } else {
            int index = 0;
            for (NamedElement nextChild : children) {
                if (!clazz.isAssignableFrom(nextChild.getClass())) break;
                ++index;
            }
            children.add(index, child);
        }
        child.addedAsChildTo(this);
    }

    public abstract void setPresentationMode(PresentationMode var1);

    public abstract PresentationMode getPresentationMode();

    public abstract Collection<ProgrammingElement> getProgrammingElements();

    @IntProperty
    public int getNumberOfProgrammingElements() {
        return this.getProgrammingElements().size();
    }

    public boolean hasAtLeastOneProgrammingElement() {
        return this.getNumberOfProgrammingElements() > 0;
    }

    public Collection<ProgrammingElement> getRelevantProgrammingElements(boolean recursively) {
        return this.getProgrammingElements();
    }

    public final Collection<ProgrammingElement> getRelevantProgrammingElements() {
        return this.getRelevantProgrammingElements(this.getPresentationMode() != PresentationMode.FLAT);
    }

    public abstract NamedElement getFirstUnderlyingElement();

    @Override
    public String getPresentationKind() {
        NamedElement underlying = this.getFirstUnderlyingElement();
        assert (underlying != null && underlying != this) : "'underlying' of method 'getPresentationKind' must not be null and not equal this";
        return underlying.getPresentationKind();
    }

    public abstract List<NamedElement> getUnderlyingElements();

    public abstract boolean isReadOnly();

    @Override
    public String getShortName() {
        return null;
    }

    @Override
    public final List<NamedElement> getAdaptedTo() {
        return this.isReadOnly() ? this.getUnderlyingElements() : Collections.emptyList();
    }

    @Override
    public abstract Language getLanguage();

    @Override
    public final void remove() {
        super.remove();
    }

    @IntProperty(undefinedValue=0)
    public int getLevel() {
        return 0;
    }

    @IntProperty(undefinedValue=-1)
    public int getCycleIndex() {
        return -1;
    }

    @IntProperty(undefinedValue=-1)
    public int getLevelInCycle() {
        return -1;
    }

    public void updateDepth() {
    }

    public int getDepth() {
        return 0;
    }

    public boolean canBeVisible() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public boolean isExpandable() {
        return true;
    }

    public boolean isExpanded() {
        return true;
    }

    public boolean isSelected() {
        return false;
    }

    public void setSelected(boolean selected) {
    }

    public boolean isParentSelected() {
        return false;
    }

    public boolean isDeleted() {
        return false;
    }

    public boolean isDeletedFlat() {
        return false;
    }

    public boolean isRemovedByFocus() {
        return false;
    }

    @Property
    public boolean hasPartialElements() {
        return false;
    }

    @Property
    public boolean hasPartialDependencies() {
        return false;
    }

    public boolean hasViolation() {
        return false;
    }

    public boolean hasDeprecation() {
        return false;
    }

    public boolean isRefactored() {
        return false;
    }

    public boolean isSuppressed() {
        return false;
    }

    public boolean isDeletedRecycled() {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isCreated() {
        return false;
    }

    public boolean isRecursive() {
        return false;
    }

    public boolean isPart() {
        return false;
    }

    public final String getElementInfo(boolean includeName, boolean includeProperties) {
        StringBuilder builder = new StringBuilder();
        if (includeName) {
            try {
                builder.append("'").append(this.getName()).append("' ");
            }
            catch (Throwable t2) {
                builder.append("'").append("<unable to determine name>").append("' ");
                LOGGER.warn("Unable to get 'name' from element.", t2);
            }
        }
        if (this.isSuppressed()) {
            builder.append("<suppressed> ");
        }
        if (includeProperties) {
            builder.append("Relative index:").append(this.getRelativeIndex()).append(",Depth:").append(this.getDepth()).append(",Level:").append(this.getLevel()).append(",Cycle index:").append(this.getCycleIndex()).append(",Mode:").append(this.getPresentationMode().getPresentationName()).append(",Visible:").append(this.isVisible()).append(",Expandable:").append(this.isExpandable()).append(",Expanded:").append(this.isExpanded()).append(",Selected:").append(this.isSelected()).append(",Hidden:").append(this.isHidden()).append(",Refactored:").append(this.isRefactored()).append(",Created:").append(this.isCreated()).append(",Deleted:").append(this.isDeleted()).append(",Deleted flat:").append(this.isDeletedFlat()).append(",Has violation:").append(this.hasViolation()).append(",Removed by focus:").append(this.isRemovedByFocus()).append(",Partial by focus:").append(this.hasPartialElements()).append(",Dependencies partial by focus:").append(this.hasPartialDependencies()).append(",Recursive:").append(this.isRecursive()).append(",Part:").append(this.isPart());
        }
        builder.append(" ('").append(this.getClass().getSimpleName());
        NamedElement firstUnderlyingElement = this.getFirstUnderlyingElement();
        if (firstUnderlyingElement != this) {
            builder.append("' for '").append(firstUnderlyingElement.getClass().getSimpleName());
        }
        builder.append("')");
        return builder.toString();
    }

    public final String getElementInfo() {
        return this.getElementInfo(true, true);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "\n" + this.getElementInfo(false, true);
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append("\n");
        builder.append("Relative path: ").append(this.getRelativePath());
        builder.append("\n");
        builder.append(this.getElementInfo());
        List<NamedElement> underlyingElements = this.getUnderlyingElements();
        builder.append("\nNumber of underlying elements: ").append(underlyingElements.size());
        for (NamedElement next : underlyingElements) {
            builder.append("\n");
            builder.append("Underlying element: " + next.getName()).append(" [").append(next.getClass().getSimpleName()).append("]");
        }
        return builder.toString();
    }

    @Override
    public void finishModification() {
        super.finishModification();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitArchitecturalViewElement(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitArchitecturalViewElement(ArchitecturalViewElement var1);
    }
}

