/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.architecture.ArtifactNameUtility;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableTargetInfo;
import java.util.HashSet;
import java.util.Set;

public final class ArchitecturalViewArtifactNameValidator
implements ITextValidator {
    private final Set<ArtifactNode> m_ignore;
    private AssignableTargetInfo m_assignableTargetInfo;

    public ArchitecturalViewArtifactNameValidator(AssignableTargetInfo assignableTargetInfo, Set<ArtifactNode> ignore) {
        assert (assignableTargetInfo != null) : "Parameter 'parent' of method 'ArchitecturalViewArtifactNameValidator' must not be null";
        this.m_ignore = new HashSet<ArtifactNode>(ignore);
        this.m_assignableTargetInfo = assignableTargetInfo;
    }

    public void setAssignableTargetInfo(AssignableTargetInfo assignableTargetInfo) {
        assert (assignableTargetInfo != null) : "Parameter 'assignableTargetInfo' of method 'setAssignableTargetInfo' must not be null";
        this.m_assignableTargetInfo = assignableTargetInfo;
    }

    public AssignableTargetInfo getAssignableTargetInfo() {
        return this.m_assignableTargetInfo;
    }

    @Override
    public ValidationResult isValid(String currentInput, String newInput) {
        String invalidInfo;
        ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
        if (newInput != null) {
            newInput = newInput.trim();
        }
        if ((invalidInfo = ArtifactNameUtility.isNameValid(newInput)) != null) {
            result.addError(invalidInfo);
        } else {
            for (ArtifactNode next : this.m_assignableTargetInfo.getTarget().getArchitecturalViewElement().getChildren(ArtifactNode.class)) {
                if (this.m_ignore.contains(next) || !next.getShortName().equals(newInput)) continue;
                result.addError("Artifact with name '" + newInput + "' already exists");
                break;
            }
        }
        return result;
    }
}

