/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.event;

import com.hello2morrow.foundation.file.IPathType;
import com.hello2morrow.sonargraph.core.model.event.ModifiablePathEvent;
import com.hello2morrow.sonargraph.core.model.path.IModifiableDirectory;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class ModifiableDirectoryPathEvent
extends ModifiablePathEvent {
    private final Set<IModifiableDirectory> m_modifiableDirectories;

    public ModifiableDirectoryPathEvent(ISoftwareSystemProvider provider, Collection<IModifiableDirectory> modifiableDirectories) {
        super(provider);
        assert (modifiableDirectories != null && !modifiableDirectories.isEmpty()) : "Parameter 'modifiableDirectories' of method 'ModifiableDirectoryPathEvent' must not be empty";
        this.m_modifiableDirectories = new HashSet<IModifiableDirectory>(modifiableDirectories);
    }

    public final Set<IModifiableDirectory> getModifiableDirectoryPaths() {
        return Collections.unmodifiableSet(this.m_modifiableDirectories);
    }

    @Override
    public final boolean containsPathOfType(IPathType ... pathTypes) {
        assert (pathTypes != null) : "Parameter 'pathTypes' of method 'containsPathOfType' must not be null";
        for (IModifiableDirectory nextModifiableDirectory : this.m_modifiableDirectories) {
            IPathType[] iPathTypeArray = pathTypes;
            int n2 = pathTypes.length;
            int n3 = 0;
            while (n3 < n2) {
                IPathType nextPathType = iPathTypeArray[n3];
                if (nextModifiableDirectory.getDirectoryType().equals(nextPathType)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }
}

