/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.event;

import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.common.IOriginator;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MetricValuesAvailableEvent
extends SoftwareSystemProviderEvent {
    private final Map<IMetricDescriptor, List<IMetricValue>> m_descriptorToValues = new HashMap<IMetricDescriptor, List<IMetricValue>>();
    private final IOriginator m_originator;

    public MetricValuesAvailableEvent(ISoftwareSystemProvider provider, IOriginator originator) {
        super(provider);
        assert (originator != null) : "Parameter 'originator' of method 'MetricValuesAvailableEvent' must not be null";
        this.m_originator = originator;
    }

    public boolean forceDispatch() {
        return true;
    }

    public IOriginator getOriginator() {
        return this.m_originator;
    }

    public void add(IMetricValue value) {
        assert (value != null) : "Parameter 'value' of method 'add' must not be null";
        IMetricDescriptor metricDescriptor = value.getMetricDescriptor();
        List<IMetricValue> values = this.m_descriptorToValues.get(metricDescriptor);
        if (values == null) {
            values = new ArrayList<IMetricValue>();
            this.m_descriptorToValues.put(metricDescriptor, values);
        }
        values.add(value);
    }

    public boolean isEmpty() {
        return this.m_descriptorToValues.isEmpty();
    }

    public Set<IMetricDescriptor> getMetricDescriptors() {
        return Collections.unmodifiableSet(this.m_descriptorToValues.keySet());
    }

    public List<IMetricValue> getMetricValues(IMetricDescriptor metricDescriptor) {
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'getMetricValues' must not be null";
        List<IMetricValue> values = this.m_descriptorToValues.get(metricDescriptor);
        return values != null ? Collections.unmodifiableList(values) : Collections.emptyList();
    }

    public String toString() {
        if (!this.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<IMetricDescriptor, List<IMetricValue>> nextEntry : this.m_descriptorToValues.entrySet()) {
                builder.append(nextEntry.getKey());
                builder.append(StringUtility.LINE_SEPARATOR);
                for (IMetricValue nextValue : nextEntry.getValue()) {
                    builder.append(nextValue);
                    builder.append(StringUtility.LINE_SEPARATOR);
                }
            }
            return builder.toString();
        }
        return "Empty";
    }
}

