/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.event;

import com.hello2morrow.foundation.file.IPathType;
import com.hello2morrow.sonargraph.core.model.event.MultipleModifiableFileEvent;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class BasicMultipleModifiableFileEvent
extends MultipleModifiableFileEvent {
    private final Set<IModifiableFile> m_modifiableFiles;

    public BasicMultipleModifiableFileEvent(ISoftwareSystemProvider provider, Collection<IModifiableFile> modifiableFiles) {
        super(provider);
        assert (modifiableFiles != null && !modifiableFiles.isEmpty()) : "Parameter 'modifiableFiles' of method 'MultipleModifiableFileEvent' must not be empty";
        this.m_modifiableFiles = new LinkedHashSet<IModifiableFile>(modifiableFiles);
    }

    public final Set<IModifiableFile> getModifiableFiles() {
        return Collections.unmodifiableSet(this.m_modifiableFiles);
    }

    @Override
    public final boolean containsPathOfType(IPathType ... pathTypes) {
        assert (pathTypes != null) : "Parameter 'pathTypes' of method 'containsPathOfType' must not be null";
        for (IModifiableFile nextModifiableFile : this.m_modifiableFiles) {
            IPathType[] iPathTypeArray = pathTypes;
            int n2 = pathTypes.length;
            int n3 = 0;
            while (n3 < n2) {
                IPathType nextPathType = iPathTypeArray[n3];
                if (nextModifiableFile.getFileType().equals(nextPathType)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }
}

