/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.enterprise;

import java.util.Objects;

public final class SonargraphEnterpriseConnection {
    public static final String X_CLIENTKEY = "X-ClientKey";
    public static final String CONNECTION_CHECK_CONTEXT = "/downloads/testClientKey";
    public static final String LIST_SYSTEMS = "/downloads/listSystems";
    public static final String LIST_SNAPSHOTS = "/downloads/listSnapshots";
    public static final String LIST_REPORTS = "/downloads/listReports";
    private final String m_server;
    private final String m_port;
    private final String m_clientKey;
    private final boolean m_useProxy;

    public SonargraphEnterpriseConnection(String server, String port, String clientKey, boolean useProxy) {
        this.m_server = server;
        this.m_port = port == null ? "" : port.trim();
        this.m_clientKey = clientKey;
        this.m_useProxy = useProxy;
    }

    public String getServer() {
        return this.m_server;
    }

    public String getPort() {
        return this.m_port;
    }

    public String getClientKey() {
        return this.m_clientKey;
    }

    public boolean useProxy() {
        return this.m_useProxy;
    }

    public String getConnectionCheckUrl() {
        if (this.m_port.length() == 0) {
            return String.valueOf(this.m_server) + CONNECTION_CHECK_CONTEXT;
        }
        return String.valueOf(this.m_server) + ":" + this.m_port + CONNECTION_CHECK_CONTEXT;
    }

    public String getServerUrl() {
        if (this.m_port.length() == 0) {
            return this.m_server;
        }
        return String.valueOf(this.m_server) + ":" + this.m_port;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SonargraphEnterpriseConnection [server=");
        builder.append(this.m_server);
        builder.append(", port=");
        builder.append(this.m_port);
        builder.append(", clientKey=");
        builder.append(this.m_clientKey);
        builder.append(", useProxy=");
        builder.append(this.m_useProxy);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.m_clientKey, this.m_port, this.m_server, this.m_useProxy);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SonargraphEnterpriseConnection other = (SonargraphEnterpriseConnection)obj;
        return Objects.equals(this.m_clientKey, other.m_clientKey) && Objects.equals(this.m_port, other.m_port) && Objects.equals(this.m_server, other.m_server) && this.m_useProxy == other.m_useProxy;
    }
}

