/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.element;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NamedElementUtility {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamedElementUtility.class);

    private NamedElementUtility() {
    }

    private static boolean check(NamedElement namedElement, Class<?> ... onlyMatching) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'check' must not be null";
        assert (onlyMatching != null) : "Parameter 'onlyMatching' of method 'check' must not be null";
        Class<?>[] classArray = onlyMatching;
        int n2 = onlyMatching.length;
        int n3 = 0;
        while (n3 < n2) {
            Class<?> next = classArray[n3];
            if (next.isAssignableFrom(namedElement.getClass())) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static <T extends NamedElement> Set<T> normalize(Collection<T> namedElements, Comparator<NamedElement> comparator, boolean parentWins, Class<?> ... onlyMatching) {
        assert (namedElements != null) : "Parameter 'namedElements' of method 'normalize' must not be null";
        assert (comparator != null) : "Parameter 'comparator' of method 'normalize' must not be null";
        if (namedElements.isEmpty()) {
            return Collections.emptySet();
        }
        LOGGER.debug("Normalizing " + namedElements.size() + " elements ...");
        ArrayList<T> sorted = new ArrayList<T>(namedElements);
        Collections.sort(sorted, comparator);
        LinkedHashSet<NamedElement> result = new LinkedHashSet<NamedElement>(sorted.size());
        LOGGER.debug("Sorted.");
        boolean checkAll = onlyMatching.length == 0;
        for (NamedElement nextInSorted : sorted) {
            boolean add = true;
            if (checkAll || NamedElementUtility.check(nextInSorted, onlyMatching)) {
                if (parentWins) {
                    for (NamedElement nextInResult : result) {
                        if (!checkAll && !NamedElementUtility.check(nextInResult, onlyMatching) || !nextInSorted.hasAsParent(nextInResult, false)) continue;
                        add = false;
                        break;
                    }
                } else {
                    for (NamedElement nextInResult : result) {
                        if (!checkAll && !NamedElementUtility.check(nextInResult, onlyMatching) || !nextInResult.hasAsParent(nextInSorted, false)) continue;
                        add = false;
                        break;
                    }
                }
            }
            if (!add) continue;
            result.add(nextInSorted);
        }
        LOGGER.debug("Normalized.");
        return result;
    }

    public static <T extends NamedElement> Set<T> normalize(Collection<T> namedElements, boolean parentWins, Class<?> ... onlyMatching) {
        assert (namedElements != null) : "Parameter 'namedElements' of method 'normalize' must not be null";
        if (namedElements.isEmpty()) {
            return Collections.emptySet();
        }
        return NamedElementUtility.normalize(namedElements, new DepthComparator(parentWins), parentWins, onlyMatching);
    }

    public static <T extends NamedElement> Map<T, T> detectChildren(Collection<T> namedElements) {
        assert (namedElements != null && !namedElements.isEmpty()) : "Parameter 'namedElements' of method 'detectChildren' must not be empty";
        if (namedElements.size() == 1) {
            return Collections.emptyMap();
        }
        ArrayList<T> sorted = new ArrayList<T>(namedElements);
        Collections.sort(sorted, new DepthComparator(true));
        HashSet<NamedElement> alreadyAdded = new HashSet<NamedElement>(sorted.size());
        LinkedHashMap<NamedElement, NamedElement> result = new LinkedHashMap<NamedElement, NamedElement>();
        for (NamedElement nextInSorted : sorted) {
            boolean add = true;
            for (NamedElement nextInResult : alreadyAdded) {
                if (!nextInSorted.hasAsParent(nextInResult, false)) continue;
                result.put(nextInSorted, nextInResult);
                add = false;
                break;
            }
            if (!add) continue;
            alreadyAdded.add(nextInSorted);
        }
        return result;
    }

    public static int getDepth(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getDepth' must not be null";
        int depth = -1;
        NamedElement current = namedElement;
        while (current != null) {
            ++depth;
            current = current.getParent();
        }
        return depth;
    }

    public static final class DepthComparator
    implements Comparator<NamedElement> {
        private final boolean m_ascending;

        public DepthComparator(boolean ascending) {
            this.m_ascending = ascending;
        }

        @Override
        public int compare(NamedElement ne1, NamedElement ne2) {
            assert (ne1 != null) : "Parameter 'ne1' of method 'compare' must not be null";
            assert (ne2 != null) : "Parameter 'ne2' of method 'compare' must not be null";
            if (this.m_ascending) {
                return NamedElementUtility.getDepth(ne1) - NamedElementUtility.getDepth(ne2);
            }
            return NamedElementUtility.getDepth(ne2) - NamedElementUtility.getDepth(ne1);
        }
    }
}

