/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.element;

import com.hello2morrow.foundation.persistence.IObjectReader;
import com.hello2morrow.foundation.persistence.IObjectWriter;
import com.hello2morrow.foundation.persistence.IPersistable;
import com.hello2morrow.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.snapshot.SnapshotArgument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class NamedElementProxy
extends NamedElement {
    private static final String ELEMENT = "element";
    private NamedElement m_element;

    public NamedElementProxy(NamedElement parent) {
        super(parent);
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeObjectReference(ELEMENT, (IPersistable)this.m_element);
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        reader.readObjectReference(ELEMENT, NamedElement.class, e2 -> {
            NamedElement namedElement = this.m_element = e2;
        });
    }

    public NamedElementProxy(NamedElement parent, NamedElement element) {
        super(parent);
        assert (element != null) : "Parameter 'element' of method 'NamedElementProxy' must not be null";
        this.m_element = element;
    }

    @Override
    public IDomainRoot.Domain getDomain() {
        IDomainRoot domainRoot = this.m_element.getParent(IDomainRoot.class, new Class[0]);
        return domainRoot != null ? domainRoot.getDomain() : null;
    }

    @Override
    public String getPresentationKind() {
        return this.m_element.getPresentationKind();
    }

    @Override
    public String getImageResourceName() {
        return this.m_element.getImageResourceName();
    }

    @Override
    public String getName() {
        return this.m_element.getName();
    }

    @Override
    public String getShortName() {
        return this.m_element.getShortName();
    }

    @Override
    public boolean isExternal() {
        return this.m_element.isExternal();
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return this.m_element.getFullyQualifiedNamePart();
    }

    @Override
    public String getPresentationName(boolean parentIsPresented) {
        return this.m_element.getPresentationName(parentIsPresented);
    }

    @Override
    public List<NamedElement> getChildren() {
        ArrayList<NamedElementProxy> result = new ArrayList<NamedElementProxy>();
        for (NamedElement element : this.m_element.getChildren()) {
            result.add(new NamedElementProxy(this, element));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public String getDescription() {
        return this.m_element.getDescription();
    }

    @Override
    public NamedElement getElement() {
        return this.m_element;
    }

    @Override
    public int getLineNumber() {
        return this.m_element.getLineNumber();
    }

    @Override
    public final Language getLanguage() {
        return this.m_element.getLanguage();
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.write(this.m_element);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_element = reader.read(NamedElement.class, new SnapshotArgument[0]);
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitNamedElementProxy(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitNamedElementProxy(NamedElementProxy var1);
    }
}

