/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.element;

import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import java.util.List;

public abstract class ElementWithIssues
extends Element {
    protected ElementWithIssues() {
    }

    @Override
    public ElementWithIssues getOriginal() {
        return this;
    }

    @Override
    public ElementWithIssues getRepresentative() {
        return this;
    }

    public abstract IIssueManager getIssueManager();

    public final void addIssue(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'addIssue' must not be null";
        assert (issue.getAffectedElement() == this.getRepresentative()) : "Issue must have been created for the element it is added to!";
        this.getIssueManager().addElementIssue(this, issue);
    }

    public final void removeIssue(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'removeIssue' must not be null";
        assert (issue.getAffectedElement() == this.getRepresentative()) : "Issue must have been created for the element it is removed from!";
        this.getIssueManager().removeElementIssue(this, issue);
    }

    public final boolean hasIssues(Severity severity) {
        return this.getIssueManager().hasElementIssues(this, severity);
    }

    @Override
    public boolean hasUnresolvedErrorIssues() {
        return this.getIssueManager().hasUnresolvedErrorIssues(this);
    }

    @Override
    public boolean hasUnresolvedWarningIssues() {
        return this.getIssueManager().hasUnresolvedWarningIssues(this);
    }

    public final boolean hasIssues(IssueCategory category) {
        assert (category != null) : "Parameter 'category' of method 'hasIssues' must not be null";
        return this.getIssueManager().hasElementIssues(this, category);
    }

    public final boolean hasIssues(IIssueId ... issueIds) {
        return this.getIssueManager().hasElementIssues(this, issueIds);
    }

    public final List<Issue> getIssues(IIssueId issueId) {
        return this.getIssueManager().getElementIssues(this, issueId);
    }

    public final List<Issue> getIssues() {
        return this.getIssueManager().getElementIssues(this);
    }

    public final void removeIssues() {
        this.getIssueManager().removeElementIssues(this);
    }

    public final void removeIssues(IIssueId ... ids) {
        this.getIssueManager().removeElementIssues(this, ids);
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        for (Issue nextIssue : this.getIssues()) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append("Issue: ");
            builder.append(nextIssue.toString());
        }
        return builder.toString();
    }

    public static interface IIssueManager {
        public void addElementIssue(ElementWithIssues var1, Issue var2);

        public boolean hasUnresolvedErrorIssues(ElementWithIssues var1);

        public boolean hasUnresolvedWarningIssues(ElementWithIssues var1);

        public boolean hasElementIssues(ElementWithIssues var1, IssueCategory var2);

        public boolean hasElementIssues(ElementWithIssues var1, IIssueId ... var2);

        public boolean hasElementIssues(ElementWithIssues var1, Severity var2);

        public List<Issue> getElementIssues(ElementWithIssues var1);

        public List<Issue> getElementIssues(ElementWithIssues var1, IIssueId var2);

        public Issue getElementIssue(ElementWithIssues var1, IIssueId var2);

        public void removeElementIssues(ElementWithIssues var1);

        public void removeElementIssues(ElementWithIssues var1, IIssueId ... var2);

        public void removeElementIssues(IIssueId ... var1);

        public void removeElementIssue(ElementWithIssues var1, Issue var2);

        public void removeIssues(IProviderId ... var1);
    }
}

