/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.dependenciesview;

import com.hello2morrow.sonargraph.core.model.dependenciesview.DeprecationInfo;
import com.hello2morrow.sonargraph.core.model.dependenciesview.ViolationInfo;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class DependenciesViewDependencyInfo {
    private Map<String, Integer> m_violationCauseToNumber;
    private Map<String, Integer> m_violationIgnoredCauseToNumber;
    private Map<String, Integer> m_violationToBeFixedCauseToNumber;
    private int m_violations;
    private int m_violationsIgnored;
    private int m_violationsToBeFixed;
    private Map<String, Integer> m_deprecationCauseToNumber;
    private Map<String, Integer> m_deprecationIgnoredCauseToNumber;
    private Map<String, Integer> m_deprecationToBeFixedCauseToNumber;
    private int m_deprecations;
    private int m_deprecationsIgnored;
    private int m_deprecationsToBeFixed;
    private Collection<Issue> m_issues;

    public void processInfo(ViolationInfo violationInfo, DeprecationInfo deprecationInfo, Collection<Issue> issues) {
        Integer number;
        String nextCause;
        Iterator<String> iterator;
        if (violationInfo != null) {
            Set<String> violationCauses = violationInfo.getCauses();
            switch (violationInfo.getResolution()) {
                case IGNORE: {
                    if (this.m_violationIgnoredCauseToNumber == null) {
                        this.m_violationIgnoredCauseToNumber = new TreeMap<String, Integer>();
                    }
                    iterator = violationCauses.iterator();
                    while (iterator.hasNext()) {
                        number = this.m_violationIgnoredCauseToNumber.get(nextCause = iterator.next());
                        this.m_violationIgnoredCauseToNumber.put(nextCause, number == null ? Integer.valueOf(1) : Integer.valueOf(number + 1));
                    }
                    ++this.m_violationsIgnored;
                    break;
                }
                case FIX: {
                    if (this.m_violationToBeFixedCauseToNumber == null) {
                        this.m_violationToBeFixedCauseToNumber = new TreeMap<String, Integer>();
                    }
                    iterator = violationCauses.iterator();
                    while (iterator.hasNext()) {
                        number = this.m_violationToBeFixedCauseToNumber.get(nextCause = iterator.next());
                        this.m_violationToBeFixedCauseToNumber.put(nextCause, number == null ? Integer.valueOf(1) : Integer.valueOf(number + 1));
                    }
                    ++this.m_violationsToBeFixed;
                    break;
                }
                case NONE: {
                    if (this.m_violationCauseToNumber == null) {
                        this.m_violationCauseToNumber = new TreeMap<String, Integer>();
                    }
                    iterator = violationCauses.iterator();
                    while (iterator.hasNext()) {
                        number = this.m_violationCauseToNumber.get(nextCause = iterator.next());
                        this.m_violationCauseToNumber.put(nextCause, number == null ? Integer.valueOf(1) : Integer.valueOf(number + 1));
                    }
                    ++this.m_violations;
                    break;
                }
            }
        }
        if (deprecationInfo != null) {
            Set<String> deprecationCauses = deprecationInfo.getCauses();
            switch (deprecationInfo.getResolution()) {
                case IGNORE: {
                    if (this.m_deprecationIgnoredCauseToNumber == null) {
                        this.m_deprecationIgnoredCauseToNumber = new TreeMap<String, Integer>();
                    }
                    iterator = deprecationCauses.iterator();
                    while (iterator.hasNext()) {
                        number = this.m_deprecationIgnoredCauseToNumber.get(nextCause = iterator.next());
                        this.m_deprecationIgnoredCauseToNumber.put(nextCause, number == null ? Integer.valueOf(1) : Integer.valueOf(number + 1));
                    }
                    ++this.m_deprecationsIgnored;
                    break;
                }
                case FIX: {
                    if (this.m_deprecationToBeFixedCauseToNumber == null) {
                        this.m_deprecationToBeFixedCauseToNumber = new TreeMap<String, Integer>();
                    }
                    iterator = deprecationCauses.iterator();
                    while (iterator.hasNext()) {
                        number = this.m_deprecationToBeFixedCauseToNumber.get(nextCause = iterator.next());
                        this.m_deprecationToBeFixedCauseToNumber.put(nextCause, number == null ? Integer.valueOf(1) : Integer.valueOf(number + 1));
                    }
                    ++this.m_deprecationsToBeFixed;
                    break;
                }
                case NONE: {
                    if (this.m_deprecationCauseToNumber == null) {
                        this.m_deprecationCauseToNumber = new TreeMap<String, Integer>();
                    }
                    iterator = deprecationCauses.iterator();
                    while (iterator.hasNext()) {
                        number = this.m_deprecationCauseToNumber.get(nextCause = iterator.next());
                        this.m_deprecationCauseToNumber.put(nextCause, number == null ? Integer.valueOf(1) : Integer.valueOf(number + 1));
                    }
                    ++this.m_deprecations;
                    break;
                }
            }
        }
        if (issues != null) {
            if (this.m_issues == null) {
                this.m_issues = new ArrayList<Issue>(issues);
            } else {
                this.m_issues.addAll(issues);
            }
        }
    }

    private String getInfo(Map<String, Integer> info, String kind) {
        assert (info != null && !info.isEmpty()) : "Parameter 'info' of method 'getInfo' must not be empty";
        assert (kind != null && kind.length() > 0) : "Parameter 'kind' of method 'getInfo' must not be empty";
        StringBuilder builder = new StringBuilder();
        builder.append(info.size()).append(" restriction(s) " + kind + ":");
        int i2 = 1;
        for (Map.Entry<String, Integer> nextEntry : info.entrySet()) {
            builder.append("\n(").append(i2++).append(") ").append(nextEntry.getKey()).append(" [").append(nextEntry.getValue()).append("]");
        }
        return builder.toString();
    }

    public int getNumberOfParserDependenciesViolating() {
        return this.m_violations;
    }

    public String getViolationInfo() {
        return this.m_violationCauseToNumber == null ? null : this.getInfo(this.m_violationCauseToNumber, "violated");
    }

    public int getNumberOfParserDependenciesViolatingToBeFixed() {
        return this.m_violationsToBeFixed;
    }

    public String getViolationInfoToBeFixed() {
        return this.m_violationToBeFixedCauseToNumber == null ? null : this.getInfo(this.m_violationToBeFixedCauseToNumber, "violated to be fixed");
    }

    public int getNumberOfParserDependenciesViolatingIgnored() {
        return this.m_violationsIgnored;
    }

    public String getViolationInfoIgnored() {
        return this.m_violationIgnoredCauseToNumber == null ? null : this.getInfo(this.m_violationIgnoredCauseToNumber, "violated");
    }

    public int getNumberOfParserDependenciesDeprecated() {
        return this.m_deprecations;
    }

    public String getDeprecationInfo() {
        return this.m_deprecationCauseToNumber == null ? null : this.getInfo(this.m_deprecationCauseToNumber, "deprecated");
    }

    public int getNumberOfParserDependenciesDeprecatedIgnored() {
        return this.m_deprecationsIgnored;
    }

    public String getDeprecationInfoIgnored() {
        return this.m_deprecationIgnoredCauseToNumber == null ? null : this.getInfo(this.m_deprecationIgnoredCauseToNumber, "deprecated");
    }

    public int getNumberOfParserDependenciesDeprecatedToBeFixed() {
        return this.m_deprecationsToBeFixed;
    }

    public String getDeprecationInfoToBeFixed() {
        return this.m_deprecationToBeFixedCauseToNumber == null ? null : this.getInfo(this.m_deprecationToBeFixedCauseToNumber, "deprecated to be fixed");
    }

    public Collection<Issue> getIssues() {
        return this.m_issues == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.m_issues);
    }
}

