/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.dependenciesview;

import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.Set;

public abstract class CausesAndResolutionInfo {
    private final Set<String> m_causes;
    private final Resolution m_resolution;

    protected CausesAndResolutionInfo(Set<String> causes, Resolution resolution) {
        assert (causes != null && !causes.isEmpty()) : "Parameter 'causes' of method 'CausesAndResolutionInfo' must not be empty";
        assert (resolution != null) : "Parameter 'resolution' of method 'CausesAndResolutionInfo' must not be null";
        this.m_causes = new THashSet(causes);
        this.m_resolution = resolution;
    }

    public final Set<String> getCauses() {
        return Collections.unmodifiableSet(this.m_causes);
    }

    public final Resolution getResolution() {
        return this.m_resolution;
    }

    public final boolean isIgnored() {
        return this.m_resolution == Resolution.IGNORE;
    }

    public final String toString() {
        return "[" + this.getClass().getSimpleName() + "] " + this.m_causes + " <Resolution:" + (Object)((Object)this.m_resolution) + ">";
    }

    public static enum Resolution {
        NONE,
        IGNORE,
        FIX;

    }
}

