/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.dashboard;

import com.hello2morrow.sonargraph.core.model.dashboard.BoxElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionApplicability;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionFilter;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionKind;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public final class ResolutionCounter
extends BoxElement {
    private final Set<ResolutionKind> m_kinds;
    private final Set<String> m_kindNames;
    private final Set<ResolutionApplicability> m_applicabilities;
    private final Set<String> m_applicabilityNames;

    public ResolutionCounter(NamedElement parent, String name, Set<ResolutionKind> kinds, Set<ResolutionApplicability> applicabilities) {
        super(parent, name);
        assert (kinds != null) : "Parameter 'kinds' of method 'ResolutionCounter' must not be null";
        assert (applicabilities != null) : "Parameter 'applicabilities' of method 'ResolutionCounter' must not be null";
        this.m_kinds = new HashSet<ResolutionKind>(kinds);
        this.m_kindNames = kinds.stream().map(k2 -> k2.getStandardName()).collect(Collectors.toSet());
        this.m_applicabilities = new HashSet<ResolutionApplicability>(applicabilities);
        this.m_applicabilityNames = applicabilities.stream().map(a2 -> a2.getStandardName()).collect(Collectors.toSet());
    }

    public ResolutionFilter createResolutionFilter() {
        ResolutionFilter resolutionFilter = new ResolutionFilter();
        for (ResolutionKind resolutionKind : this.m_kinds) {
            resolutionFilter.add(resolutionKind);
        }
        for (ResolutionApplicability resolutionApplicability : this.m_applicabilities) {
            resolutionFilter.add(resolutionApplicability);
        }
        return resolutionFilter;
    }

    public boolean match(String resolutionKind, String applicability) {
        if (this.m_kindNames.size() > 0 && !this.m_kindNames.contains(resolutionKind)) {
            return false;
        }
        return this.m_applicabilityNames.size() <= 0 || this.m_applicabilityNames.contains(applicability);
    }

    public Set<ResolutionKind> getKinds() {
        return this.m_kinds;
    }

    public Set<ResolutionApplicability> getApplicabilities() {
        return this.m_applicabilities;
    }

    @Override
    public String getLabel() {
        return this.getName();
    }
}

