/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.dashboard;

import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.dashboard.BoxElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionMode;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public final class IssueCounter
extends BoxElement {
    private final Set<String> m_severityNames;
    private final Set<String> m_categoryNames;
    private final Set<String> m_resolutionKindNames;

    public IssueCounter(NamedElement parent, String name, Set<Severity> severities, Set<IssueCategory> categories, Set<ResolutionMode> resolutionModes) {
        super(parent, name);
        assert (severities != null) : "Parameter 'severities' of method 'IssueCounter' must not be null";
        assert (categories != null) : "Parameter 'categories' of method 'IssueCounter' must not be null";
        assert (resolutionModes != null) : "Parameter 'resolutionModes' of method 'IssueCounter' must not be null";
        this.m_severityNames = severities.isEmpty() ? Collections.emptySet() : severities.stream().map(s2 -> s2.getStandardName()).collect(Collectors.toSet());
        this.m_categoryNames = categories.isEmpty() ? Collections.emptySet() : categories.stream().map(c2 -> c2.getStandardName()).collect(Collectors.toSet());
        this.m_resolutionKindNames = resolutionModes.isEmpty() ? Collections.emptySet() : resolutionModes.stream().map(r2 -> r2.getStandardName()).collect(Collectors.toSet());
    }

    public boolean match(String severityName, String categoryName, String resolutionModeName) {
        if (!this.m_severityNames.isEmpty() && !this.m_severityNames.contains(severityName)) {
            return false;
        }
        if (!this.m_categoryNames.isEmpty() && !this.m_categoryNames.contains(categoryName)) {
            return false;
        }
        return this.m_resolutionKindNames.isEmpty() || this.m_resolutionKindNames.contains(resolutionModeName);
    }

    @Override
    public String getLabel() {
        return this.getName();
    }
}

