/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.context;

import com.hello2morrow.foundation.propertyreader.IntProperty;
import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.RefactoringState;
import com.hello2morrow.sonargraph.core.model.programming.IParserDependencyContext;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;

public abstract class ContextParserDependency
extends Dependency {
    private final ParserDependency m_dependency;

    public ContextParserDependency(ParserDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'ContextParserDependency' must not be null";
        this.m_dependency = dependency;
    }

    @Override
    public final ParserDependency getElement() {
        return this.m_dependency;
    }

    @Override
    public final RefactoringState getRefactoringState() {
        return this.m_dependency.getRefactoringState();
    }

    @Override
    public final boolean hasBeenDirectlyRefactored() {
        return this.m_dependency.hasBeenDirectlyRefactored();
    }

    public boolean isViolation() {
        return this.m_dependency.isViolation();
    }

    public boolean isDeprecation() {
        return this.m_dependency.isDeprecation();
    }

    public void refreshViolationState() {
    }

    @Override
    @IntProperty
    public final int getLineNumber() {
        return this.m_dependency.getLineNumber();
    }

    @Override
    public final String getImageResourceName() {
        if (!this.m_dependency.isArchitectureRelevant()) {
            return "ArrowGrayRight";
        }
        if (this.isViolation()) {
            return "ViolatingParserDependency";
        }
        if (this.isDeprecation()) {
            return "DeprecatedParserDependency";
        }
        return ParserDependency.class.getSimpleName();
    }

    @Override
    public final ProgrammingElement getFrom() {
        return this.m_dependency.getFrom();
    }

    @Override
    public final ProgrammingElement getTo() {
        return this.m_dependency.getTo();
    }

    @Override
    public final NamedElement getUnderlyingFrom() {
        return this.m_dependency.getUnderlyingFrom();
    }

    @Override
    public final NamedElement getUnderlyingTo() {
        return this.m_dependency.getUnderlyingTo();
    }

    @Override
    public final ElementWithIssues.IIssueManager getIssueManager() {
        return this.m_dependency.getIssueManager();
    }

    @Override
    public final boolean isValid() {
        return this.m_dependency.isValid();
    }

    @Override
    public final String getShortName() {
        return this.m_dependency.getShortName();
    }

    @Override
    public final Element.IPropertiesManager getPropertiesManager() {
        return this.m_dependency.getPropertiesManager();
    }

    @Property
    public final String getDependencyInfoDescription() {
        return this.m_dependency.getDependencyInfoDescription();
    }

    @Property
    public final IParserDependencyType getDependencyType() {
        return this.m_dependency.getDependencyType();
    }

    @Property
    public final IParserDependencyContext getDependencyContext() {
        return this.m_dependency.getDependencyContext();
    }

    @Property
    public final IParserDependencyType getGenericDependencyType() {
        return this.getDependencyType().getGenericDependencyType();
    }

    @Property
    public final IParserDependencyContext getGenericDependencyContext() {
        IParserDependencyContext context = this.getDependencyContext();
        return context != null ? context.getGenericDependencyContext() : null;
    }

    @Override
    @Property
    public final String getDependencyInfo() {
        return this.getDependencyType().getPresentationName();
    }
}

