/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.foundation.utilities.CustomPattern;
import com.hello2morrow.sonargraph.core.model.architecture.AssignableFilter;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.architecture.ParsedPatternInfo;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;

public class PatternFilter
extends AssignableFilter {
    private final String m_pattern;
    private final CustomPattern m_customPattern;

    public PatternFilter(NamedElement parent, IAssignableAttributeRetriever retriever, String originalPattern, String pattern, boolean isStrong, String[] params, int lineNumber) {
        super(parent, retriever, isStrong, false, originalPattern, params, lineNumber);
        assert (pattern != null && pattern.length() > 0) : "Parameter 'pattern' of method 'PatternFilter' must not be empty";
        this.m_pattern = pattern;
        this.m_customPattern = CustomPattern.compileWildcardPattern((String)pattern, (String)(retriever == null ? "/" : retriever.getBreakCharacters()), (boolean)false, (boolean)true);
    }

    public PatternFilter(ParsedPatternInfo info, int lineNumber) {
        super(null, info.getRetriever(), info.isStrong(), info.isOptional(), info.getOriginalPattern(), info.getParams(), lineNumber);
        assert (info != null) : "Parameter 'info' of method 'PatternFilter' must not be null";
        this.m_pattern = info.getPattern();
        this.m_customPattern = info.getCompiledPattern();
    }

    public final String getPattern() {
        return this.m_pattern;
    }

    @Override
    protected boolean isMatching(String toBeMatched) {
        assert (toBeMatched != null && toBeMatched.length() > 0) : "Parameter 'toBeMatched' of method 'isMatching' must not be empty";
        if (this.m_customPattern.matches((CharSequence)toBeMatched)) {
            ++this.m_matchingCount;
            return true;
        }
        return false;
    }

    @Override
    public String[] getLastCaptureGroups() {
        return this.m_customPattern.getLastCaptureGroups();
    }
}

