/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;

public interface IArchitecturalModelProvider {
    public ArchitectureModel getModel();

    public static final class ArchitectureModel
    extends Enum<ArchitectureModel>
    implements IStandardEnumeration {
        public static final /* enum */ ArchitectureModel LOGICAL = new ArchitectureModel(IDomainRoot.Domain.ARCHITECTURE_LOGICAL, "Top-Level Programming Elements");
        public static final /* enum */ ArchitectureModel PHYSICAL = new ArchitectureModel(IDomainRoot.Domain.ARCHITECTURE_PHYSICAL, "Components");
        private final IDomainRoot.Domain m_domain;
        private final String m_assignableElements;
        private static final /* synthetic */ ArchitectureModel[] ENUM$VALUES;

        static {
            ENUM$VALUES = new ArchitectureModel[]{LOGICAL, PHYSICAL};
        }

        private ArchitectureModel(IDomainRoot.Domain domain, String assignableElement) {
            assert (domain != null) : "Parameter 'domain' of method 'ArchitectureModel' must not be null";
            assert (assignableElement != null && assignableElement.length() > 0) : "Parameter 'assignableElement' of method 'ArchitectureModel' must not be empty";
            this.m_domain = domain;
            this.m_assignableElements = assignableElement;
        }

        public IDomainRoot.Domain getDomain() {
            return this.m_domain;
        }

        public String getAssignableElements() {
            return this.m_assignableElements;
        }

        public String getStandardName() {
            return this.name().toLowerCase();
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }

        public static ArchitectureModel fromStandardName(String standardName) throws IllegalArgumentException {
            return ArchitectureModel.valueOf(standardName != null ? standardName.toUpperCase() : standardName);
        }

        public static ArchitectureModel[] values() {
            ArchitectureModel[] architectureModelArray = ENUM$VALUES;
            int n2 = architectureModelArray.length;
            ArchitectureModel[] architectureModelArray2 = new ArchitectureModel[n2];
            System.arraycopy(ENUM$VALUES, 0, architectureModelArray2, 0, n2);
            return architectureModelArray2;
        }

        public static ArchitectureModel valueOf(String string) {
            return Enum.valueOf(ArchitectureModel.class, string);
        }
    }
}

