/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

public final class ArtifactNameUtility {
    private static final String ARTIFACT_NAME_INFO = "Allowed are letters, digits, '_' and '-'. Must begin with a letter.";
    private static final char UNDERSCORE = '_';

    private ArtifactNameUtility() {
    }

    public static String createValidName(String proposal) {
        assert (proposal != null && proposal.length() > 0) : "Parameter 'proposal' of method 'createValidName' must not be empty";
        StringBuilder builder = new StringBuilder();
        char firstChar = proposal.charAt(0);
        if (!Character.isJavaIdentifierStart(firstChar)) {
            builder.append('_');
        } else {
            builder.append(firstChar);
        }
        int i2 = 1;
        while (i2 < proposal.length()) {
            char c2 = proposal.charAt(i2);
            if (c2 != '-' && !Character.isJavaIdentifierPart(c2)) {
                builder.append('_');
            } else {
                builder.append(c2);
            }
            ++i2;
        }
        return builder.toString();
    }

    public static String isNameValid(String name) {
        if (name == null || name.isEmpty()) {
            return "Must not be empty";
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return ARTIFACT_NAME_INFO;
        }
        int i2 = 1;
        while (i2 < name.length()) {
            char c2 = name.charAt(i2);
            if (c2 != '-' && !Character.isJavaIdentifierPart(c2)) {
                return ARTIFACT_NAME_INFO;
            }
            ++i2;
        }
        return null;
    }
}

