/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureContextParserDependency;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureViolationIssueId;
import com.hello2morrow.sonargraph.core.model.context.ContextParserDependency;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import java.util.ArrayList;
import java.util.List;

public final class ArchitectureViewContext
implements IContext {
    private final IContext m_defaultContext;
    private final IProviderId m_providerId;

    public ArchitectureViewContext(IContext defaultContext, IProviderId providerId) {
        assert (defaultContext != null) : "Parameter 'defaultContext' of method 'ArchitectureViewContext' must not be null";
        assert (providerId != null) : "Parameter 'providerId' of method 'ArchitectureViewContext' must not be null";
        this.m_defaultContext = defaultContext;
        this.m_providerId = providerId;
    }

    @Override
    public boolean isValid() {
        return this.m_defaultContext.isValid();
    }

    public String getStandardName() {
        return this.m_defaultContext.getStandardName();
    }

    public String getPresentationName() {
        return this.m_defaultContext.getPresentationName();
    }

    @Override
    public boolean isViolation(ParserDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'isViolation' must not be null";
        return dependency.isViolation(this.m_providerId);
    }

    @Override
    public ContextParserDependency create(ParserDependency dependency) {
        return new ArchitectureContextParserDependency(dependency, this.isViolation(dependency));
    }

    @Override
    public String getViolationInfo(ParserDependency dependency) {
        List<Issue> issues;
        assert (dependency != null) : "Parameter 'dependency' of method 'getViolationInfo' must not be null";
        if (this.isViolation(dependency) && !(issues = dependency.getIssues(ArchitectureViolationIssueId.INSTANCE)).isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Issue next : issues) {
                builder.append(next.getDescription()).append(",");
            }
            builder.deleteCharAt(builder.length() - 1);
            return builder.toString();
        }
        return null;
    }

    @Override
    public String getDescription() {
        return "Provides access to violations in the Architecture view";
    }

    @Override
    public List<Issue> collectIssues(ElementWithIssues element, boolean recursively) {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        if (element instanceof NamedElement) {
            issues.addAll(this.m_defaultContext.collectIssues(element, recursively));
        } else {
            assert (element != null && element instanceof Dependency) : "Unexpected class in method 'collectIssues': " + element;
            if (!(element instanceof ParserDependency)) {
                issues.addAll(this.m_defaultContext.collectIssues(element, recursively));
            } else {
                for (Issue next : element.getIssues()) {
                    if (next.getId() == ArchitectureViolationIssueId.INSTANCE) {
                        if (!this.isViolation((ParserDependency)element)) continue;
                        issues.add(next);
                        continue;
                    }
                    if (next.isIgnored()) continue;
                    issues.add(next);
                }
            }
        }
        issues.trimToSize();
        return issues;
    }
}

