/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.foundation.persistence.IObjectReader;
import com.hello2morrow.foundation.persistence.IObjectWriter;
import com.hello2morrow.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureIssueWithLineNumber;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import java.io.IOException;

public class ArchitectureFileIssue
extends ArchitectureIssueWithLineNumber {
    private static final String IS_ERROR = "isError";
    private static final String COL = "col";
    private int m_column;
    private boolean m_isError;

    public ArchitectureFileIssue() {
    }

    public ArchitectureFileIssue(ArchitectureFile element, String description, int line, int column, boolean isError) {
        super(element, description, line);
        this.m_column = column;
        this.m_isError = isError;
    }

    public ArchitectureFileIssue(ArchitectureFile element, String description, int line, int column) {
        this(element, description, line, column, true);
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeInt(COL, this.m_column);
        writer.writeBoolean(IS_ERROR, this.m_isError);
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        this.m_column = reader.readInt(COL);
        this.m_isError = reader.readBoolean(IS_ERROR);
    }

    @Override
    public IIssueId getId() {
        return this.m_isError ? CoreIssueId.ARCHITECTURE_FILE_ERROR : CoreIssueId.ARCHITECTURE_FILE_WARNING;
    }

    @Override
    public int getColumn() {
        return this.m_column;
    }
}

