/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureProviderId;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.programming.DynamicDependencyIssue;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import java.util.EnumSet;
import java.util.Set;

public abstract class ArchitectureCheckIssue
extends DynamicDependencyIssue {
    private static final String DEPENDENCY = " -> ";
    private final ArchitectureProviderId m_issueProviderId;
    private final String m_artifactDependency;
    private final String m_restriction;

    public ArchitectureCheckIssue(ParserDependency element, String description, ArchitectureProviderId providerId, String artifactFromPath, String artifactToPath, String restriction) {
        super(element, description);
        assert (providerId != null) : "Parameter 'providerId' of method 'ArchitectureViolationIssue' must not be null";
        assert (artifactFromPath != null && artifactFromPath.length() > 0) : "Parameter 'artifactFromPath' of method 'ArchitectureViolationIssue' must not be empty";
        assert (artifactToPath != null && artifactToPath.length() > 0) : "Parameter 'artifactToPath' of method 'ArchitectureViolationIssue' must not be empty";
        assert (restriction != null && restriction.length() > 0) : "Parameter 'restriction' of method 'ArchitectureViolationIssue' must not be empty";
        this.m_issueProviderId = providerId;
        this.m_artifactDependency = (String.valueOf(artifactFromPath) + DEPENDENCY + artifactToPath).intern();
        this.m_restriction = restriction.intern();
    }

    @Override
    public ParserDependency getAffectedElement() {
        return (ParserDependency)super.getAffectedElement();
    }

    @Override
    public IProviderId getProvider() {
        return this.m_issueProviderId;
    }

    @Override
    public Set<AnalyzerGroup> getAdditionallyAffectedAnalyzerGroups() {
        return EnumSet.of(AnalyzerGroup.ARCHITECTURE_METRICS);
    }

    @Override
    public String getKey() {
        return String.valueOf(super.getKey()) + ":" + this.m_issueProviderId.getIdentifier();
    }

    @Property
    public String getArtifactDependency() {
        return this.m_artifactDependency;
    }

    public static String getArtifactFromPath(String artifactDependency) {
        assert (artifactDependency != null && artifactDependency.length() > 0) : "Parameter 'artifactDependency' of method 'getArtifactFromPath' must not be empty";
        int pos = artifactDependency.indexOf(DEPENDENCY);
        assert (pos != -1) : "Wrong artifact dependency info format: " + artifactDependency;
        return artifactDependency.substring(0, pos);
    }

    public static String getArtifactToPath(String artifactDependency) {
        assert (artifactDependency != null && artifactDependency.length() > 0) : "Parameter 'artifactDependency' of method 'getArtifactToPath' must not be empty";
        int pos = artifactDependency.indexOf(DEPENDENCY);
        assert (pos != -1) : "Wrong artifact dependency info format: " + artifactDependency;
        return artifactDependency.substring(pos + DEPENDENCY.length());
    }

    public String getArtifactFromPath() {
        return ArchitectureCheckIssue.getArtifactFromPath(this.m_artifactDependency);
    }

    public String getRestriction() {
        return this.m_restriction;
    }
}

