/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.architecture.DirectoryFragmentComponentContainer;
import com.hello2morrow.sonargraph.core.model.architecture.ExternalLogicalNamespaceContainer;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureCheckStatusProvider;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureDefinitionElement;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.IClearableArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.LibraryComponentContainer;
import com.hello2morrow.sonargraph.core.model.architecture.LogicalNamespaceContainer;
import com.hello2morrow.sonargraph.core.model.architecture.NamespaceFragmentComponentContainer;
import com.hello2morrow.sonargraph.core.model.architecture.RootDirectoryPathComponentContainer;
import com.hello2morrow.sonargraph.core.model.architecture.WorkspaceRootComponentContainer;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.IModelRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.LibraryPath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.ExternalElementContainer;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleNamespace;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ArchitectureBaseElement
extends NamedElementContainer
implements IArchitectureDefinitionElement,
IClearableArchitectureElement {
    private final Set<IAssignableToArtifact> m_assignedElements = new THashSet();
    private boolean m_builtComponentProxyTree;

    public ArchitectureBaseElement(NamedElement parent) {
        super(parent);
    }

    @Override
    public final NamedElement getNamedElement() {
        return this;
    }

    @Override
    public IDomainRoot.Domain getDomain() {
        return this.getParent(IDomainRoot.class, new Class[0]).getDomain();
    }

    public boolean isEmpty() {
        return this.m_assignedElements.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NamedElement> getChildrenList() {
        ArrayList<NamedElement> result = new ArrayList<NamedElement>();
        ArchitectureBaseElement architectureBaseElement = this;
        synchronized (architectureBaseElement) {
            result.addAll(super.getChildrenList());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.m_assignedElements.clear();
        if (this.m_builtComponentProxyTree) {
            ArchitectureBaseElement architectureBaseElement = this;
            synchronized (architectureBaseElement) {
                ArrayList<NamedElement> children = this.getModifiableChildrenList();
                if (children != null && !children.isEmpty()) {
                    for (NamedElement nextChild : new ArrayList<NamedElement>(children)) {
                        if (nextChild instanceof IArchitectureElement) continue;
                        nextChild.remove();
                    }
                }
                this.m_builtComponentProxyTree = false;
            }
        }
    }

    private NamedElement getParentProxyFor(NamedElement realParent, IArchitecturalModelProvider.ArchitectureModel model, Map<NamedElement, NamedElement> physicalToArchitectureProxyParents) {
        assert (realParent != null) : "Parameter 'realParent' of method 'getParentProxyFor' must not be null";
        assert (model != null) : "Parameter 'model' of method 'getParentProxyFor' must not be null";
        assert (physicalToArchitectureProxyParents != null) : "Parameter 'physicalToArchitectureProxyParents' of method 'getParentProxyFor' must not be null";
        NamedElement proxyParent = physicalToArchitectureProxyParents.get(realParent);
        if (proxyParent != null) {
            return proxyParent;
        }
        if (model.equals((Object)IArchitecturalModelProvider.ArchitectureModel.PHYSICAL)) {
            if (realParent.getParent() instanceof IModelRoot) {
                proxyParent = new WorkspaceRootComponentContainer((NamedElement)this, realParent);
                this.addChild(proxyParent);
            } else {
                NamedElement proxyGrandParent = this.getParentProxyFor(realParent.getParent(), model, physicalToArchitectureProxyParents);
                if (realParent instanceof NamespaceFragment) {
                    proxyParent = new NamespaceFragmentComponentContainer(proxyGrandParent, (NamespaceFragment)realParent);
                } else if (realParent instanceof RootDirectoryPath) {
                    proxyParent = new RootDirectoryPathComponentContainer(proxyGrandParent, (RootDirectoryPath)realParent);
                } else if (realParent instanceof DirectoryFragment) {
                    proxyParent = new DirectoryFragmentComponentContainer(proxyGrandParent, (DirectoryFragment)realParent);
                } else if (realParent instanceof LibraryPath) {
                    proxyParent = new LibraryComponentContainer(proxyGrandParent, (LibraryPath)realParent);
                } else assert (false) : "Unexpected class: " + realParent.getClass();
                proxyGrandParent.addChild(proxyParent);
            }
        } else {
            assert (model.equals((Object)IArchitecturalModelProvider.ArchitectureModel.LOGICAL));
            if (realParent.getParent() instanceof IModelRoot) {
                proxyParent = new WorkspaceRootComponentContainer((NamedElement)this, realParent);
                this.addChild(proxyParent);
            } else {
                NamedElement proxyGrandParent = this.getParentProxyFor(realParent.getParent(), model, physicalToArchitectureProxyParents);
                if (realParent instanceof LogicalModuleNamespace) {
                    proxyParent = new LogicalNamespaceContainer(proxyGrandParent, (LogicalModuleNamespace)realParent);
                } else if (realParent instanceof ExternalElementContainer) {
                    proxyParent = new ExternalLogicalNamespaceContainer(proxyGrandParent, (ExternalElementContainer)realParent);
                } else assert (false) : "Unexpected class: " + realParent.getClass();
                proxyGrandParent.addChild(proxyParent);
            }
        }
        physicalToArchitectureProxyParents.put(realParent, proxyParent);
        return proxyParent;
    }

    private final void addProxyFor(IAssignableToArtifact assignedElement, IArchitecturalModelProvider.ArchitectureModel model, Map<NamedElement, NamedElement> physicalToArchitectureProxyParents) {
        assert (assignedElement != null) : "Parameter 'assignedElement' of method 'addProxyFor' must not be null";
        assert (model != null) : "Parameter 'model' of method 'addProxyFor' must not be null";
        assert (physicalToArchitectureProxyParents != null) : "Parameter 'physicalToArchitectureProxyParents' of method 'addProxyFor' must not be null";
        NamedElement parentProxy = this.getParentProxyFor(assignedElement.getNamedElement().getParent(), model, physicalToArchitectureProxyParents);
        AssignedElement proxy = new AssignedElement(parentProxy, assignedElement);
        parentProxy.addChild(proxy);
    }

    public void assignComponent(IAssignableToArtifact assignable) {
        assert (assignable != null) : "Parameter 'component' of method 'assignComponent' must not be null";
        this.m_assignedElements.add(assignable);
        this.m_builtComponentProxyTree = false;
    }

    public final boolean contains(IAssignableToArtifact component) {
        assert (component != null) : "Parameter 'component' of method 'contains' must not be null";
        return this.m_assignedElements.contains(component);
    }

    public final boolean contains(Collection<? extends IAssignableToArtifact> components) {
        assert (components != null) : "Parameter 'components' of method 'contains' must not be null";
        return this.m_assignedElements.containsAll(components);
    }

    public Collection<IAssignableToArtifact> getAssignedElements() {
        return Collections.unmodifiableSet(this.m_assignedElements);
    }

    @IntProperty
    public int getNumberOfAssignedElements() {
        return this.m_assignedElements.size();
    }

    @Override
    public boolean hasChildren() {
        return this.m_assignedElements.size() > 0 || super.getNumberOfChildren() > 0;
    }

    protected void buildProxyTree() {
        if (!this.m_builtComponentProxyTree) {
            THashMap physicalToArchitectureProxyParents = new THashMap();
            Collection<IAssignableToArtifact> assignedElements = this.getAssignedElements();
            IArchitecturalModelProvider.ArchitectureModel model = this.getParent(IArchitecturalModelProvider.class, ParentMode.SELF_OR_FIRST_PARENT).getModel();
            for (IAssignableToArtifact nextElement : assignedElements) {
                this.addProxyFor(nextElement, model, (Map<NamedElement, NamedElement>)physicalToArchitectureProxyParents);
            }
            this.m_builtComponentProxyTree = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<NamedElement> getAllChildren() {
        if (!this.m_builtComponentProxyTree) {
            ArchitectureBaseElement architectureBaseElement = this;
            synchronized (architectureBaseElement) {
                this.buildProxyTree();
            }
        }
        return this.getChildren();
    }

    public boolean checked() {
        return this.getParent(IArchitectureCheckStatusProvider.class, new Class[0]).isChecked();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitArchitectureBaseElement(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitArchitectureBaseElement(ArchitectureBaseElement var1);
    }
}

