/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.sonargraph.core.model.common.AutoCompletionProposal;
import java.util.Objects;

public final class ArchitectureAutoCompletionProposal
extends AutoCompletionProposal {
    private final Type m_type;

    public ArchitectureAutoCompletionProposal(String proposal, int replacementOffset, int replacementLength, int offsetIncrement, Type type) {
        super(proposal, replacementOffset, replacementLength, offsetIncrement);
        assert (type != null) : "Parameter 'type' of method 'ArchitectureAutoCompletionProposal' must not be null";
        this.m_type = type;
    }

    public ArchitectureAutoCompletionProposal(String proposal, int replacementOffset, int replacementLength, Type type) {
        this(proposal, replacementOffset, replacementLength, 0, type);
    }

    @Override
    public String getImageResourceName() {
        switch (this.m_type) {
            case ARTIFACT: {
                return "Artifact";
            }
            case CONNECTOR: {
                return "Connector";
            }
            case INTERFACE: {
                return "Interface";
            }
            case KEYWORD: {
                return "Keyword";
            }
        }
        assert (false) : "Unhandled type: " + (Object)((Object)this.m_type);
        return "";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(new Object[]{this.m_type});
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        ArchitectureAutoCompletionProposal other = (ArchitectureAutoCompletionProposal)obj;
        return this.m_type == other.m_type;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " <" + (Object)((Object)this.m_type) + ">";
    }

    public static enum Type {
        KEYWORD,
        ARTIFACT,
        INTERFACE,
        CONNECTOR;

    }
}

