/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableFilter;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import java.util.Set;

public class AndFilter
extends NamedElement
implements IAssignableFilter {
    private IAssignableFilter m_leftFilter;
    private IAssignableFilter m_rightFilter;
    private int m_matchingCount = 0;

    public AndFilter(IAssignableFilter leftFilter, IAssignableFilter rightFilter) {
        super(null);
        this.m_leftFilter = leftFilter;
        this.m_rightFilter = rightFilter;
    }

    @Override
    public String getShortName() {
        return this.getOriginalPattern();
    }

    @Override
    public boolean matches(IWorkerContext workerContext, IAssignableToArtifact assignable) {
        if (!this.m_leftFilter.matches(workerContext, assignable)) {
            return false;
        }
        if (this.m_rightFilter.matches(workerContext, assignable)) {
            ++this.m_matchingCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(IWorkerContext workerContext, IAssignableToArtifact assignable, String context, Set<String> multipleAttributeInfoCollector) {
        if (!this.m_leftFilter.matches(workerContext, assignable)) {
            return false;
        }
        if (this.m_rightFilter.matches(workerContext, assignable, context, multipleAttributeInfoCollector)) {
            ++this.m_matchingCount;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.m_matchingCount = 0;
        this.m_leftFilter.reset();
        this.m_rightFilter.reset();
    }

    @Override
    public int getLineNumber() {
        return this.m_leftFilter.getLineNumber();
    }

    @Override
    public boolean isStrong() {
        return this.m_leftFilter.isStrong();
    }

    @Override
    public String getOriginalPattern() {
        return String.format("\"%s\" and \"%s\"", this.m_leftFilter.getOriginalPattern(), this.m_rightFilter.getOriginalPattern());
    }

    @Override
    public String[] getLastCaptureGroups() {
        return this.m_leftFilter.getLastCaptureGroups();
    }

    @Override
    public int getMatchingCount() {
        return this.m_matchingCount;
    }

    @Override
    public AndFilter clone() {
        return (AndFilter)super.clone();
    }
}

