/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationWithWarnings;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurationCreator;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import java.util.Map;

public final class SystemDiffAnalyzerConfiguration
extends AnalyzerConfigurationWithWarnings {
    public static final String BASELINE_PATH = "baselinePath";
    private static final String COMPLETENESS = "completeness";
    private static final String ENABLED = "enabled";
    static final IConfigurationCreator CREATOR = new IConfigurationCreator(){

        @Override
        public AnalyzerConfiguration create(NamedElement parent, IAnalyzerId analyzerId) {
            return new SystemDiffAnalyzerConfiguration(parent, analyzerId);
        }

        @Override
        public String getImageResourceName() {
            return "SystemDiffConfiguration";
        }
    };

    public SystemDiffAnalyzerConfiguration(NamedElement parent, IAnalyzerId analyzerId) {
        super(parent, analyzerId);
    }

    private SystemDiffAnalyzerConfiguration(SystemDiffAnalyzerConfiguration configuration) {
        super(configuration);
    }

    @Override
    public SystemDiffAnalyzerConfiguration copy() {
        return new SystemDiffAnalyzerConfiguration(this);
    }

    @Override
    protected void removeVolatileEntries(Map<String, Object> entries) {
        assert (entries != null) : "Parameter 'entries' of method 'removeVolatileEntries' must not be null";
        entries.remove(COMPLETENESS);
    }

    public void setBaselinePath(String baselineReportPath) {
        if (baselineReportPath != null) {
            this.addValue(BASELINE_PATH, baselineReportPath);
        } else {
            this.removeValue(BASELINE_PATH);
        }
    }

    public String getBaselinePath() {
        return (String)this.getValue(BASELINE_PATH);
    }

    public void setEnabled(boolean isEnabled) {
        this.addValue(ENABLED, isEnabled);
    }

    public boolean isEnabled() {
        Boolean enabled = (Boolean)this.getValue(ENABLED);
        return enabled != null ? enabled : false;
    }
}

