/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;

public abstract class MetricThreshold
extends NamedElement
implements IMetricThreshold {
    private final String m_metricId;
    private final String m_metricLevel;
    private IMetricDescriptor m_metricDescriptor;
    private Severity m_severity;

    protected MetricThreshold(NamedElement parent, IMetricDescriptor metricDescriptor, Severity severity) {
        super(parent);
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'MetricThreshold' must not be null";
        assert (severity != null) : "Parameter 'severity' of method 'MetricThreshold' must not be null";
        this.m_metricDescriptor = metricDescriptor;
        this.m_metricId = this.m_metricDescriptor.getMetricId().getStandardName();
        this.m_metricLevel = this.m_metricDescriptor.getLevel().getStandardName();
        this.m_severity = severity;
    }

    public String getMetricId() {
        return this.m_metricId;
    }

    public String getMetricLevel() {
        return this.m_metricLevel;
    }

    public final void setMetricDescriptor(IMetricDescriptor metricDescriptor) {
        this.m_metricDescriptor = metricDescriptor;
    }

    @Override
    public final IMetricDescriptor getMetricDescriptor() {
        return this.m_metricDescriptor;
    }

    @Override
    public final Severity getSeverity() {
        return this.m_severity;
    }

    @Override
    public final void setSeverity(Severity severity) {
        assert (severity != null) : "Parameter 'severity' of method 'setSeverity' must not be null";
        this.m_severity = severity;
    }

    @Override
    public final boolean isValid() {
        return super.isValid() && this.m_metricDescriptor != null;
    }

    @Override
    public final String getShortName() {
        return "Threshold for '" + this.m_metricDescriptor.getName() + "' [" + NumberUtility.format((Number)this.getLowerThreshold()) + " " + NumberUtility.format((Number)this.getUpperThreshold()) + " " + this.getSeverity().name() + "]";
    }

    @Override
    public String getInformation() {
        return this.m_metricDescriptor.getPresentationName();
    }

    @Override
    public final String getKey() {
        return String.valueOf(this.m_metricDescriptor.getMetricId().getStandardName()) + ":" + this.m_metricDescriptor.getLevel().getStandardName();
    }

    @Override
    public abstract String getValue();

    @Override
    public final boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }
}

