/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricThreshold;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;

public final class IntegerThreshold
extends MetricThreshold {
    private int m_lowerThreshold;
    private int m_upperThreshold;

    public IntegerThreshold(NamedElement parent, IMetricDescriptor descriptor, int lowerThreshold, int upperThreshold, Severity severity) {
        super(parent, descriptor, severity);
        this.m_lowerThreshold = lowerThreshold;
        this.m_upperThreshold = upperThreshold;
    }

    public IntegerThreshold(NamedElement parent, IMetricDescriptor descriptor, String encodedThresholds) {
        super(parent, descriptor, Severity.WARNING);
        assert (encodedThresholds != null && encodedThresholds.length() > 0) : "Parameter 'encodedThresholds' of method 'IntegerThreshold' must not be empty";
        String[] thresholds = encodedThresholds.split(":");
        this.m_lowerThreshold = Integer.parseInt(thresholds[0]);
        this.m_upperThreshold = Integer.parseInt(thresholds[1]);
        if (thresholds.length > 2) {
            Severity severity = Severity.valueOf(thresholds[2]);
            this.setSeverity(severity);
        }
    }

    @Override
    public Number getLowerThreshold() {
        return this.m_lowerThreshold;
    }

    @Override
    public Number getUpperThreshold() {
        return this.m_upperThreshold;
    }

    @Override
    public void setLowerThreshold(Number n2) {
        this.m_lowerThreshold = n2.intValue();
    }

    @Override
    public void setUpperThreshold(Number n2) {
        this.m_upperThreshold = n2.intValue();
    }

    @Override
    public boolean isViolatedBy(Number value) {
        assert (value != null) : "Parameter 'value' of method 'isViolatedBy' must not be null";
        int v2 = value.intValue();
        return v2 < this.m_lowerThreshold || v2 > this.m_upperThreshold;
    }

    @Override
    public String getValue() {
        return String.format("%d:%d:%s", this.m_lowerThreshold, this.m_upperThreshold, this.getSeverity().name());
    }
}

