/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurationCreator;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;

public final class DuplicateCodeAnalyzerConfiguration
extends AnalyzerConfiguration {
    static final IConfigurationCreator CREATOR = new IConfigurationCreator(){

        @Override
        public AnalyzerConfiguration create(NamedElement parent, IAnalyzerId analyzerId) {
            return new DuplicateCodeAnalyzerConfiguration(parent, analyzerId);
        }

        @Override
        public String getImageResourceName() {
            return "DuplicateCodeCheckConfiguration";
        }
    };

    public DuplicateCodeAnalyzerConfiguration(NamedElement parent, IAnalyzerId analyzerId) {
        super(parent, analyzerId);
        ConfigurationEntryDescriptor[] configurationEntryDescriptorArray = ConfigurationEntryDescriptor.values();
        int n2 = configurationEntryDescriptorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ConfigurationEntryDescriptor descriptor = configurationEntryDescriptorArray[n3];
            this.addValue(descriptor.getStandardName(), descriptor.getDefaultValue());
            ++n3;
        }
    }

    @Override
    public void reset() {
        super.reset();
        ConfigurationEntryDescriptor[] configurationEntryDescriptorArray = ConfigurationEntryDescriptor.values();
        int n2 = configurationEntryDescriptorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ConfigurationEntryDescriptor descriptor = configurationEntryDescriptorArray[n3];
            this.addValue(descriptor.getStandardName(), descriptor.getDefaultValue());
            ++n3;
        }
    }

    private DuplicateCodeAnalyzerConfiguration(DuplicateCodeAnalyzerConfiguration configuration) {
        super(configuration);
    }

    @Override
    public DuplicateCodeAnalyzerConfiguration copy() {
        return new DuplicateCodeAnalyzerConfiguration(this);
    }

    @Property
    public int getMinimalLineLength() {
        return (Integer)this.getValue(ConfigurationEntryDescriptor.MINIMAL_LINE_LENGTH.getStandardName());
    }

    @Property
    public int getMaximalTolerancePerEdit() {
        return (Integer)this.getValue(ConfigurationEntryDescriptor.MAXIMAL_TOLERANCE_PER_EDIT.getStandardName());
    }

    @Property
    public int getMinimalBlockLength() {
        return (Integer)this.getValue(ConfigurationEntryDescriptor.MINIMAL_BLOCK_LENGTH.getStandardName());
    }

    @Property
    public int getMaximumNumberOfCopies() {
        return (Integer)this.getValue(ConfigurationEntryDescriptor.MAXIMAL_NUMBER_OF_COPIES.getStandardName());
    }

    @Property
    public int getMaximumRelativeTolerancePercentage() {
        return (Integer)this.getValue(ConfigurationEntryDescriptor.MAXIMAL_RELATIVE_TOLERANCE_PERCENTAGE.getStandardName());
    }

    public static final class ConfigurationEntryDescriptor
    extends Enum<ConfigurationEntryDescriptor>
    implements AnalyzerConfiguration.IIntegerConfigurationEntryDescriptor {
        public static final /* enum */ ConfigurationEntryDescriptor MINIMAL_LINE_LENGTH = new ConfigurationEntryDescriptor(3, 1, 9999999, "Minimal Line Length: Lines shorter than the minimal line length are ignored during duplicate search.");
        public static final /* enum */ ConfigurationEntryDescriptor MINIMAL_BLOCK_LENGTH = new ConfigurationEntryDescriptor(25, 1, 9999999, "Minimal Block Length: Duplicate blocks shorter than a given number of lines are not signalled. Ignored lines are not counted.");
        public static final /* enum */ ConfigurationEntryDescriptor MAXIMAL_NUMBER_OF_COPIES = new ConfigurationEntryDescriptor(100, 1, 9999999, "Maximal Number of Copies: If a line occurs more often than this, it is ignored when looking for start lines of duplicated blocks.");
        public static final /* enum */ ConfigurationEntryDescriptor MAXIMAL_TOLERANCE_PER_EDIT = new ConfigurationEntryDescriptor(3, 1, 9999999, "Maximal Tolerance per Edit: When two text blocks are compared by comparing lines from start to end, the comparison algorithm allows for some differences.  The \"Maximal Tolerance per Edit\" is the maximum allowed number of non-matching relevant lines in a sequence between identical sub-blocks. Relevant lines are lines that are not ignored due to any other configuration setting (like, e.g., \"Minimal Line Length\").");
        public static final /* enum */ ConfigurationEntryDescriptor MAXIMAL_RELATIVE_TOLERANCE_PERCENTAGE = new ConfigurationEntryDescriptor(35, 1, 100, "Maximal Relative Tolerance Percentage: When comparing two blocks, the number of edited lines in relation to the number of matched lines may never be larger than this percentage.");
        private final int m_defaultValue;
        private final int m_minimalValue;
        private final int m_maximalValue;
        private final String m_description;
        private static final /* synthetic */ ConfigurationEntryDescriptor[] ENUM$VALUES;

        static {
            ENUM$VALUES = new ConfigurationEntryDescriptor[]{MINIMAL_LINE_LENGTH, MINIMAL_BLOCK_LENGTH, MAXIMAL_NUMBER_OF_COPIES, MAXIMAL_TOLERANCE_PER_EDIT, MAXIMAL_RELATIVE_TOLERANCE_PERCENTAGE};
        }

        private ConfigurationEntryDescriptor(Integer defaultValue, Integer minimalValue, Integer maximalValue, String description) {
            assert (description != null && description.length() > 0) : "Parameter 'description' of method 'ConfigurationEntryDescriptor' must not be empty";
            this.m_defaultValue = defaultValue;
            this.m_description = description;
            this.m_minimalValue = minimalValue;
            this.m_maximalValue = maximalValue;
        }

        @Override
        public Integer getDefaultValue() {
            return this.m_defaultValue;
        }

        @Override
        public int getMaxValue() {
            return this.m_maximalValue;
        }

        @Override
        public int getMinValue() {
            return this.m_minimalValue;
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return this.m_description;
        }

        public static ConfigurationEntryDescriptor[] values() {
            ConfigurationEntryDescriptor[] configurationEntryDescriptorArray = ENUM$VALUES;
            int n2 = configurationEntryDescriptorArray.length;
            ConfigurationEntryDescriptor[] configurationEntryDescriptorArray2 = new ConfigurationEntryDescriptor[n2];
            System.arraycopy(ENUM$VALUES, 0, configurationEntryDescriptorArray2, 0, n2);
            return configurationEntryDescriptorArray2;
        }

        public static ConfigurationEntryDescriptor valueOf(String string) {
            return Enum.valueOf(ConfigurationEntryDescriptor.class, string);
        }
    }
}

