/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.foundation.persistence.IObjectReader;
import com.hello2morrow.foundation.persistence.IObjectWriter;
import com.hello2morrow.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueWithDescription;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;

public final class CycleGroupIssue
extends CoreIssueWithDescription {
    private static final String ISSUE_ID = "issueId";
    private static final String SEVERITY = "severity";
    private IAnalyzerId m_analyzerId;
    private IIssueId m_issueId;
    private Severity m_severity;

    public CycleGroupIssue() {
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeEnumConstant(SEVERITY, (Enum)this.m_severity);
        writer.writeOther(ISSUE_ID, (Object)this.m_issueId);
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        this.m_severity = (Severity)reader.readEnumConstant(SEVERITY, Severity.class);
        reader.readOther(ISSUE_ID, IIssueId.class, id -> {
            IIssueId iIssueId = this.m_issueId = id;
        });
        this.m_analyzerId = (IAnalyzerId)reader.getVariable("analyzerId", IAnalyzerId.class);
    }

    public CycleGroupIssue(NamedElement affectedElement, String description, IAnalyzerId analyzerId, IIssueId issueId, Severity severity) {
        super(affectedElement, description);
        assert (analyzerId != null) : "Parameter 'analyzerId' of method 'CycleIssue' must not be null";
        assert (issueId != null) : "Parameter 'issueId' of method 'CycleIssue' must not be null";
        assert (severity != null) : "Parameter 'severity' of method 'CycleGroupIssue' must not be null";
        this.m_analyzerId = analyzerId;
        this.m_issueId = issueId;
        this.m_severity = severity;
    }

    @Override
    public Set<AnalyzerGroup> getAdditionallyAffectedAnalyzerGroups() {
        return EnumSet.of(AnalyzerGroup.CYCLE_METRICS, AnalyzerGroup.ENTANGLEMENT);
    }

    @Override
    public IIssueId getId() {
        return this.m_issueId;
    }

    @Override
    public Severity getSeverity() {
        return this.m_severity;
    }

    @Override
    public IAnalyzerId getAnalyzerId() {
        return this.m_analyzerId;
    }
}

